/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class IntersectionTypeDescriptorNode
extends TypeDescriptorNode {
    public IntersectionTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Node leftTypeDesc() {
        return this.childInBucket(0);
    }

    public Token bitwiseAndToken() {
        return (Token)this.childInBucket(1);
    }

    public Node rightTypeDesc() {
        return this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"leftTypeDesc", "bitwiseAndToken", "rightTypeDesc"};
    }

    public IntersectionTypeDescriptorNode modify(Node leftTypeDesc, Token bitwiseAndToken, Node rightTypeDesc) {
        if (this.checkForReferenceEquality(leftTypeDesc, bitwiseAndToken, rightTypeDesc)) {
            return this;
        }
        return NodeFactory.createIntersectionTypeDescriptorNode(leftTypeDesc, bitwiseAndToken, rightTypeDesc);
    }

    public IntersectionTypeDescriptorNodeModifier modify() {
        return new IntersectionTypeDescriptorNodeModifier(this);
    }

    public static class IntersectionTypeDescriptorNodeModifier {
        private final IntersectionTypeDescriptorNode oldNode;
        private Node leftTypeDesc;
        private Token bitwiseAndToken;
        private Node rightTypeDesc;

        public IntersectionTypeDescriptorNodeModifier(IntersectionTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.leftTypeDesc = oldNode.leftTypeDesc();
            this.bitwiseAndToken = oldNode.bitwiseAndToken();
            this.rightTypeDesc = oldNode.rightTypeDesc();
        }

        public IntersectionTypeDescriptorNodeModifier withLeftTypeDesc(Node leftTypeDesc) {
            Objects.requireNonNull(leftTypeDesc, "leftTypeDesc must not be null");
            this.leftTypeDesc = leftTypeDesc;
            return this;
        }

        public IntersectionTypeDescriptorNodeModifier withBitwiseAndToken(Token bitwiseAndToken) {
            Objects.requireNonNull(bitwiseAndToken, "bitwiseAndToken must not be null");
            this.bitwiseAndToken = bitwiseAndToken;
            return this;
        }

        public IntersectionTypeDescriptorNodeModifier withRightTypeDesc(Node rightTypeDesc) {
            Objects.requireNonNull(rightTypeDesc, "rightTypeDesc must not be null");
            this.rightTypeDesc = rightTypeDesc;
            return this;
        }

        public IntersectionTypeDescriptorNode apply() {
            return this.oldNode.modify(this.leftTypeDesc, this.bitwiseAndToken, this.rightTypeDesc);
        }
    }
}

