/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import java.util.Objects;

public class LetVariableDeclarationNode
extends NonTerminalNode {
    public LetVariableDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public TypedBindingPatternNode typedBindingPattern() {
        return (TypedBindingPatternNode)this.childInBucket(1);
    }

    public Token equalsToken() {
        return (Token)this.childInBucket(2);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "typedBindingPattern", "equalsToken", "expression"};
    }

    public LetVariableDeclarationNode modify(NodeList<AnnotationNode> annotations, TypedBindingPatternNode typedBindingPattern, Token equalsToken, ExpressionNode expression) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), typedBindingPattern, equalsToken, expression)) {
            return this;
        }
        return NodeFactory.createLetVariableDeclarationNode(annotations, typedBindingPattern, equalsToken, expression);
    }

    public LetVariableDeclarationNodeModifier modify() {
        return new LetVariableDeclarationNodeModifier(this);
    }

    public static class LetVariableDeclarationNodeModifier {
        private final LetVariableDeclarationNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private TypedBindingPatternNode typedBindingPattern;
        private Token equalsToken;
        private ExpressionNode expression;

        public LetVariableDeclarationNodeModifier(LetVariableDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.typedBindingPattern = oldNode.typedBindingPattern();
            this.equalsToken = oldNode.equalsToken();
            this.expression = oldNode.expression();
        }

        public LetVariableDeclarationNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public LetVariableDeclarationNodeModifier withTypedBindingPattern(TypedBindingPatternNode typedBindingPattern) {
            Objects.requireNonNull(typedBindingPattern, "typedBindingPattern must not be null");
            this.typedBindingPattern = typedBindingPattern;
            return this;
        }

        public LetVariableDeclarationNodeModifier withEqualsToken(Token equalsToken) {
            Objects.requireNonNull(equalsToken, "equalsToken must not be null");
            this.equalsToken = equalsToken;
            return this;
        }

        public LetVariableDeclarationNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public LetVariableDeclarationNode apply() {
            return this.oldNode.modify(this.annotations, this.typedBindingPattern, this.equalsToken, this.expression);
        }
    }
}

