/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ListenerDeclarationNode
extends ModuleMemberDeclarationNode {
    public ListenerDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public Optional<Token> visibilityQualifier() {
        return this.optionalChildInBucket(1);
    }

    public Token listenerKeyword() {
        return (Token)this.childInBucket(2);
    }

    public Node typeDescriptor() {
        return this.childInBucket(3);
    }

    public Token variableName() {
        return (Token)this.childInBucket(4);
    }

    public Token equalsToken() {
        return (Token)this.childInBucket(5);
    }

    public Node initializer() {
        return this.childInBucket(6);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(7);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "visibilityQualifier", "listenerKeyword", "typeDescriptor", "variableName", "equalsToken", "initializer", "semicolonToken"};
    }

    public ListenerDeclarationNode modify(MetadataNode metadata, Token visibilityQualifier, Token listenerKeyword, Node typeDescriptor, Token variableName, Token equalsToken, Node initializer, Token semicolonToken) {
        if (this.checkForReferenceEquality(metadata, visibilityQualifier, listenerKeyword, typeDescriptor, variableName, equalsToken, initializer, semicolonToken)) {
            return this;
        }
        return NodeFactory.createListenerDeclarationNode(metadata, visibilityQualifier, listenerKeyword, typeDescriptor, variableName, equalsToken, initializer, semicolonToken);
    }

    public ListenerDeclarationNodeModifier modify() {
        return new ListenerDeclarationNodeModifier(this);
    }

    public static class ListenerDeclarationNodeModifier {
        private final ListenerDeclarationNode oldNode;
        private MetadataNode metadata;
        private Token visibilityQualifier;
        private Token listenerKeyword;
        private Node typeDescriptor;
        private Token variableName;
        private Token equalsToken;
        private Node initializer;
        private Token semicolonToken;

        public ListenerDeclarationNodeModifier(ListenerDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.visibilityQualifier = oldNode.visibilityQualifier().orElse(null);
            this.listenerKeyword = oldNode.listenerKeyword();
            this.typeDescriptor = oldNode.typeDescriptor();
            this.variableName = oldNode.variableName();
            this.equalsToken = oldNode.equalsToken();
            this.initializer = oldNode.initializer();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public ListenerDeclarationNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public ListenerDeclarationNodeModifier withVisibilityQualifier(Token visibilityQualifier) {
            this.visibilityQualifier = visibilityQualifier;
            return this;
        }

        public ListenerDeclarationNodeModifier withListenerKeyword(Token listenerKeyword) {
            Objects.requireNonNull(listenerKeyword, "listenerKeyword must not be null");
            this.listenerKeyword = listenerKeyword;
            return this;
        }

        public ListenerDeclarationNodeModifier withTypeDescriptor(Node typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public ListenerDeclarationNodeModifier withVariableName(Token variableName) {
            Objects.requireNonNull(variableName, "variableName must not be null");
            this.variableName = variableName;
            return this;
        }

        public ListenerDeclarationNodeModifier withEqualsToken(Token equalsToken) {
            Objects.requireNonNull(equalsToken, "equalsToken must not be null");
            this.equalsToken = equalsToken;
            return this;
        }

        public ListenerDeclarationNodeModifier withInitializer(Node initializer) {
            Objects.requireNonNull(initializer, "initializer must not be null");
            this.initializer = initializer;
            return this;
        }

        public ListenerDeclarationNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public ListenerDeclarationNode apply() {
            return this.oldNode.modify(this.metadata, this.visibilityQualifier, this.listenerKeyword, this.typeDescriptor, this.variableName, this.equalsToken, this.initializer, this.semicolonToken);
        }
    }
}

