/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class NamedArgBindingPatternNode
extends BindingPatternNode {
    public NamedArgBindingPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public IdentifierToken argName() {
        return (IdentifierToken)this.childInBucket(0);
    }

    public Token equalsToken() {
        return (Token)this.childInBucket(1);
    }

    public BindingPatternNode bindingPattern() {
        return (BindingPatternNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"argName", "equalsToken", "bindingPattern"};
    }

    public NamedArgBindingPatternNode modify(IdentifierToken argName, Token equalsToken, BindingPatternNode bindingPattern) {
        if (this.checkForReferenceEquality(argName, equalsToken, bindingPattern)) {
            return this;
        }
        return NodeFactory.createNamedArgBindingPatternNode(argName, equalsToken, bindingPattern);
    }

    public NamedArgBindingPatternNodeModifier modify() {
        return new NamedArgBindingPatternNodeModifier(this);
    }

    public static class NamedArgBindingPatternNodeModifier {
        private final NamedArgBindingPatternNode oldNode;
        private IdentifierToken argName;
        private Token equalsToken;
        private BindingPatternNode bindingPattern;

        public NamedArgBindingPatternNodeModifier(NamedArgBindingPatternNode oldNode) {
            this.oldNode = oldNode;
            this.argName = oldNode.argName();
            this.equalsToken = oldNode.equalsToken();
            this.bindingPattern = oldNode.bindingPattern();
        }

        public NamedArgBindingPatternNodeModifier withArgName(IdentifierToken argName) {
            Objects.requireNonNull(argName, "argName must not be null");
            this.argName = argName;
            return this;
        }

        public NamedArgBindingPatternNodeModifier withEqualsToken(Token equalsToken) {
            Objects.requireNonNull(equalsToken, "equalsToken must not be null");
            this.equalsToken = equalsToken;
            return this;
        }

        public NamedArgBindingPatternNodeModifier withBindingPattern(BindingPatternNode bindingPattern) {
            Objects.requireNonNull(bindingPattern, "bindingPattern must not be null");
            this.bindingPattern = bindingPattern;
            return this;
        }

        public NamedArgBindingPatternNode apply() {
            return this.oldNode.modify(this.argName, this.equalsToken, this.bindingPattern);
        }
    }
}

