/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class NamedWorkerDeclarationNode
extends NonTerminalNode {
    public NamedWorkerDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public Optional<Token> transactionalKeyword() {
        return this.optionalChildInBucket(1);
    }

    public Token workerKeyword() {
        return (Token)this.childInBucket(2);
    }

    public IdentifierToken workerName() {
        return (IdentifierToken)this.childInBucket(3);
    }

    public Optional<Node> returnTypeDesc() {
        return this.optionalChildInBucket(4);
    }

    public BlockStatementNode workerBody() {
        return (BlockStatementNode)this.childInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "transactionalKeyword", "workerKeyword", "workerName", "returnTypeDesc", "workerBody"};
    }

    public NamedWorkerDeclarationNode modify(NodeList<AnnotationNode> annotations, Token transactionalKeyword, Token workerKeyword, IdentifierToken workerName, Node returnTypeDesc, BlockStatementNode workerBody) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), transactionalKeyword, workerKeyword, workerName, returnTypeDesc, workerBody)) {
            return this;
        }
        return NodeFactory.createNamedWorkerDeclarationNode(annotations, transactionalKeyword, workerKeyword, workerName, returnTypeDesc, workerBody);
    }

    public NamedWorkerDeclarationNodeModifier modify() {
        return new NamedWorkerDeclarationNodeModifier(this);
    }

    public static class NamedWorkerDeclarationNodeModifier {
        private final NamedWorkerDeclarationNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private Token transactionalKeyword;
        private Token workerKeyword;
        private IdentifierToken workerName;
        private Node returnTypeDesc;
        private BlockStatementNode workerBody;

        public NamedWorkerDeclarationNodeModifier(NamedWorkerDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.transactionalKeyword = oldNode.transactionalKeyword().orElse(null);
            this.workerKeyword = oldNode.workerKeyword();
            this.workerName = oldNode.workerName();
            this.returnTypeDesc = oldNode.returnTypeDesc().orElse(null);
            this.workerBody = oldNode.workerBody();
        }

        public NamedWorkerDeclarationNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public NamedWorkerDeclarationNodeModifier withTransactionalKeyword(Token transactionalKeyword) {
            this.transactionalKeyword = transactionalKeyword;
            return this;
        }

        public NamedWorkerDeclarationNodeModifier withWorkerKeyword(Token workerKeyword) {
            Objects.requireNonNull(workerKeyword, "workerKeyword must not be null");
            this.workerKeyword = workerKeyword;
            return this;
        }

        public NamedWorkerDeclarationNodeModifier withWorkerName(IdentifierToken workerName) {
            Objects.requireNonNull(workerName, "workerName must not be null");
            this.workerName = workerName;
            return this;
        }

        public NamedWorkerDeclarationNodeModifier withReturnTypeDesc(Node returnTypeDesc) {
            this.returnTypeDesc = returnTypeDesc;
            return this;
        }

        public NamedWorkerDeclarationNodeModifier withWorkerBody(BlockStatementNode workerBody) {
            Objects.requireNonNull(workerBody, "workerBody must not be null");
            this.workerBody = workerBody;
            return this;
        }

        public NamedWorkerDeclarationNode apply() {
            return this.oldNode.modify(this.annotations, this.transactionalKeyword, this.workerKeyword, this.workerName, this.returnTypeDesc, this.workerBody);
        }
    }
}

