/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class NilLiteralNode
extends ExpressionNode {
    public NilLiteralNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openParenToken() {
        return (Token)this.childInBucket(0);
    }

    public Token closeParenToken() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openParenToken", "closeParenToken"};
    }

    public NilLiteralNode modify(Token openParenToken, Token closeParenToken) {
        if (this.checkForReferenceEquality(openParenToken, closeParenToken)) {
            return this;
        }
        return NodeFactory.createNilLiteralNode(openParenToken, closeParenToken);
    }

    public NilLiteralNodeModifier modify() {
        return new NilLiteralNodeModifier(this);
    }

    public static class NilLiteralNodeModifier {
        private final NilLiteralNode oldNode;
        private Token openParenToken;
        private Token closeParenToken;

        public NilLiteralNodeModifier(NilLiteralNode oldNode) {
            this.oldNode = oldNode;
            this.openParenToken = oldNode.openParenToken();
            this.closeParenToken = oldNode.closeParenToken();
        }

        public NilLiteralNodeModifier withOpenParenToken(Token openParenToken) {
            Objects.requireNonNull(openParenToken, "openParenToken must not be null");
            this.openParenToken = openParenToken;
            return this;
        }

        public NilLiteralNodeModifier withCloseParenToken(Token closeParenToken) {
            Objects.requireNonNull(closeParenToken, "closeParenToken must not be null");
            this.closeParenToken = closeParenToken;
            return this;
        }

        public NilLiteralNode apply() {
            return this.oldNode.modify(this.openParenToken, this.closeParenToken);
        }
    }
}

