/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ObjectFieldNode
extends NonTerminalNode {
    public ObjectFieldNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public Optional<Token> visibilityQualifier() {
        return this.optionalChildInBucket(1);
    }

    public Optional<Token> finalKeyword() {
        return this.optionalChildInBucket(2);
    }

    public Node typeName() {
        return this.childInBucket(3);
    }

    public Token fieldName() {
        return (Token)this.childInBucket(4);
    }

    public Optional<Token> equalsToken() {
        return this.optionalChildInBucket(5);
    }

    public Optional<ExpressionNode> expression() {
        return this.optionalChildInBucket(6);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(7);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "visibilityQualifier", "finalKeyword", "typeName", "fieldName", "equalsToken", "expression", "semicolonToken"};
    }

    public ObjectFieldNode modify(MetadataNode metadata, Token visibilityQualifier, Token finalKeyword, Node typeName, Token fieldName, Token equalsToken, ExpressionNode expression, Token semicolonToken) {
        if (this.checkForReferenceEquality(metadata, visibilityQualifier, finalKeyword, typeName, fieldName, equalsToken, expression, semicolonToken)) {
            return this;
        }
        return NodeFactory.createObjectFieldNode(metadata, visibilityQualifier, finalKeyword, typeName, fieldName, equalsToken, expression, semicolonToken);
    }

    public ObjectFieldNodeModifier modify() {
        return new ObjectFieldNodeModifier(this);
    }

    public static class ObjectFieldNodeModifier {
        private final ObjectFieldNode oldNode;
        private MetadataNode metadata;
        private Token visibilityQualifier;
        private Token finalKeyword;
        private Node typeName;
        private Token fieldName;
        private Token equalsToken;
        private ExpressionNode expression;
        private Token semicolonToken;

        public ObjectFieldNodeModifier(ObjectFieldNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.visibilityQualifier = oldNode.visibilityQualifier().orElse(null);
            this.finalKeyword = oldNode.finalKeyword().orElse(null);
            this.typeName = oldNode.typeName();
            this.fieldName = oldNode.fieldName();
            this.equalsToken = oldNode.equalsToken().orElse(null);
            this.expression = oldNode.expression().orElse(null);
            this.semicolonToken = oldNode.semicolonToken();
        }

        public ObjectFieldNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public ObjectFieldNodeModifier withVisibilityQualifier(Token visibilityQualifier) {
            this.visibilityQualifier = visibilityQualifier;
            return this;
        }

        public ObjectFieldNodeModifier withFinalKeyword(Token finalKeyword) {
            this.finalKeyword = finalKeyword;
            return this;
        }

        public ObjectFieldNodeModifier withTypeName(Node typeName) {
            Objects.requireNonNull(typeName, "typeName must not be null");
            this.typeName = typeName;
            return this;
        }

        public ObjectFieldNodeModifier withFieldName(Token fieldName) {
            Objects.requireNonNull(fieldName, "fieldName must not be null");
            this.fieldName = fieldName;
            return this;
        }

        public ObjectFieldNodeModifier withEqualsToken(Token equalsToken) {
            this.equalsToken = equalsToken;
            return this;
        }

        public ObjectFieldNodeModifier withExpression(ExpressionNode expression) {
            this.expression = expression;
            return this;
        }

        public ObjectFieldNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public ObjectFieldNode apply() {
            return this.oldNode.modify(this.metadata, this.visibilityQualifier, this.finalKeyword, this.typeName, this.fieldName, this.equalsToken, this.expression, this.semicolonToken);
        }
    }
}

