/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class OptionalTypeDescriptorNode
extends TypeDescriptorNode {
    public OptionalTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Node typeDescriptor() {
        return this.childInBucket(0);
    }

    public Token questionMarkToken() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"typeDescriptor", "questionMarkToken"};
    }

    public OptionalTypeDescriptorNode modify(Node typeDescriptor, Token questionMarkToken) {
        if (this.checkForReferenceEquality(typeDescriptor, questionMarkToken)) {
            return this;
        }
        return NodeFactory.createOptionalTypeDescriptorNode(typeDescriptor, questionMarkToken);
    }

    public OptionalTypeDescriptorNodeModifier modify() {
        return new OptionalTypeDescriptorNodeModifier(this);
    }

    public static class OptionalTypeDescriptorNodeModifier {
        private final OptionalTypeDescriptorNode oldNode;
        private Node typeDescriptor;
        private Token questionMarkToken;

        public OptionalTypeDescriptorNodeModifier(OptionalTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.typeDescriptor = oldNode.typeDescriptor();
            this.questionMarkToken = oldNode.questionMarkToken();
        }

        public OptionalTypeDescriptorNodeModifier withTypeDescriptor(Node typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public OptionalTypeDescriptorNodeModifier withQuestionMarkToken(Token questionMarkToken) {
            Objects.requireNonNull(questionMarkToken, "questionMarkToken must not be null");
            this.questionMarkToken = questionMarkToken;
            return this;
        }

        public OptionalTypeDescriptorNode apply() {
            return this.oldNode.modify(this.typeDescriptor, this.questionMarkToken);
        }
    }
}

