/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class PanicStatementNode
extends StatementNode {
    public PanicStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token panicKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"panicKeyword", "expression", "semicolonToken"};
    }

    public PanicStatementNode modify(Token panicKeyword, ExpressionNode expression, Token semicolonToken) {
        if (this.checkForReferenceEquality(panicKeyword, expression, semicolonToken)) {
            return this;
        }
        return NodeFactory.createPanicStatementNode(panicKeyword, expression, semicolonToken);
    }

    public PanicStatementNodeModifier modify() {
        return new PanicStatementNodeModifier(this);
    }

    public static class PanicStatementNodeModifier {
        private final PanicStatementNode oldNode;
        private Token panicKeyword;
        private ExpressionNode expression;
        private Token semicolonToken;

        public PanicStatementNodeModifier(PanicStatementNode oldNode) {
            this.oldNode = oldNode;
            this.panicKeyword = oldNode.panicKeyword();
            this.expression = oldNode.expression();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public PanicStatementNodeModifier withPanicKeyword(Token panicKeyword) {
            Objects.requireNonNull(panicKeyword, "panicKeyword must not be null");
            this.panicKeyword = panicKeyword;
            return this;
        }

        public PanicStatementNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public PanicStatementNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public PanicStatementNode apply() {
            return this.oldNode.modify(this.panicKeyword, this.expression, this.semicolonToken);
        }
    }
}

