/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnConflictClauseNode;
import io.ballerina.compiler.syntax.tree.QueryConstructTypeNode;
import io.ballerina.compiler.syntax.tree.QueryPipelineNode;
import io.ballerina.compiler.syntax.tree.SelectClauseNode;
import java.util.Objects;
import java.util.Optional;

public class QueryExpressionNode
extends ExpressionNode {
    public QueryExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<QueryConstructTypeNode> queryConstructType() {
        return this.optionalChildInBucket(0);
    }

    public QueryPipelineNode queryPipeline() {
        return (QueryPipelineNode)this.childInBucket(1);
    }

    public SelectClauseNode selectClause() {
        return (SelectClauseNode)this.childInBucket(2);
    }

    public Optional<OnConflictClauseNode> onConflictClause() {
        return this.optionalChildInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"queryConstructType", "queryPipeline", "selectClause", "onConflictClause"};
    }

    public QueryExpressionNode modify(QueryConstructTypeNode queryConstructType, QueryPipelineNode queryPipeline, SelectClauseNode selectClause, OnConflictClauseNode onConflictClause) {
        if (this.checkForReferenceEquality(queryConstructType, queryPipeline, selectClause, onConflictClause)) {
            return this;
        }
        return NodeFactory.createQueryExpressionNode(queryConstructType, queryPipeline, selectClause, onConflictClause);
    }

    public QueryExpressionNodeModifier modify() {
        return new QueryExpressionNodeModifier(this);
    }

    public static class QueryExpressionNodeModifier {
        private final QueryExpressionNode oldNode;
        private QueryConstructTypeNode queryConstructType;
        private QueryPipelineNode queryPipeline;
        private SelectClauseNode selectClause;
        private OnConflictClauseNode onConflictClause;

        public QueryExpressionNodeModifier(QueryExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.queryConstructType = oldNode.queryConstructType().orElse(null);
            this.queryPipeline = oldNode.queryPipeline();
            this.selectClause = oldNode.selectClause();
            this.onConflictClause = oldNode.onConflictClause().orElse(null);
        }

        public QueryExpressionNodeModifier withQueryConstructType(QueryConstructTypeNode queryConstructType) {
            this.queryConstructType = queryConstructType;
            return this;
        }

        public QueryExpressionNodeModifier withQueryPipeline(QueryPipelineNode queryPipeline) {
            Objects.requireNonNull(queryPipeline, "queryPipeline must not be null");
            this.queryPipeline = queryPipeline;
            return this;
        }

        public QueryExpressionNodeModifier withSelectClause(SelectClauseNode selectClause) {
            Objects.requireNonNull(selectClause, "selectClause must not be null");
            this.selectClause = selectClause;
            return this;
        }

        public QueryExpressionNodeModifier withOnConflictClause(OnConflictClauseNode onConflictClause) {
            this.onConflictClause = onConflictClause;
            return this;
        }

        public QueryExpressionNode apply() {
            return this.oldNode.modify(this.queryConstructType, this.queryPipeline, this.selectClause, this.onConflictClause);
        }
    }
}

