/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ReceiveFieldsNode
extends NonTerminalNode {
    public ReceiveFieldsNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBrace() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<NameReferenceNode> receiveFields() {
        return new SeparatedNodeList<NameReferenceNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBrace() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBrace", "receiveFields", "closeBrace"};
    }

    public ReceiveFieldsNode modify(Token openBrace, SeparatedNodeList<NameReferenceNode> receiveFields, Token closeBrace) {
        if (this.checkForReferenceEquality(openBrace, receiveFields.underlyingListNode(), closeBrace)) {
            return this;
        }
        return NodeFactory.createReceiveFieldsNode(openBrace, receiveFields, closeBrace);
    }

    public ReceiveFieldsNodeModifier modify() {
        return new ReceiveFieldsNodeModifier(this);
    }

    public static class ReceiveFieldsNodeModifier {
        private final ReceiveFieldsNode oldNode;
        private Token openBrace;
        private SeparatedNodeList<NameReferenceNode> receiveFields;
        private Token closeBrace;

        public ReceiveFieldsNodeModifier(ReceiveFieldsNode oldNode) {
            this.oldNode = oldNode;
            this.openBrace = oldNode.openBrace();
            this.receiveFields = oldNode.receiveFields();
            this.closeBrace = oldNode.closeBrace();
        }

        public ReceiveFieldsNodeModifier withOpenBrace(Token openBrace) {
            Objects.requireNonNull(openBrace, "openBrace must not be null");
            this.openBrace = openBrace;
            return this;
        }

        public ReceiveFieldsNodeModifier withReceiveFields(SeparatedNodeList<NameReferenceNode> receiveFields) {
            Objects.requireNonNull(receiveFields, "receiveFields must not be null");
            this.receiveFields = receiveFields;
            return this;
        }

        public ReceiveFieldsNodeModifier withCloseBrace(Token closeBrace) {
            Objects.requireNonNull(closeBrace, "closeBrace must not be null");
            this.closeBrace = closeBrace;
            return this;
        }

        public ReceiveFieldsNode apply() {
            return this.oldNode.modify(this.openBrace, this.receiveFields, this.closeBrace);
        }
    }
}

