/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class RestMatchPatternNode
extends NonTerminalNode {
    public RestMatchPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ellipsisToken() {
        return (Token)this.childInBucket(0);
    }

    public Token varKeywordToken() {
        return (Token)this.childInBucket(1);
    }

    public SimpleNameReferenceNode variableName() {
        return (SimpleNameReferenceNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ellipsisToken", "varKeywordToken", "variableName"};
    }

    public RestMatchPatternNode modify(Token ellipsisToken, Token varKeywordToken, SimpleNameReferenceNode variableName) {
        if (this.checkForReferenceEquality(ellipsisToken, varKeywordToken, variableName)) {
            return this;
        }
        return NodeFactory.createRestMatchPatternNode(ellipsisToken, varKeywordToken, variableName);
    }

    public RestMatchPatternNodeModifier modify() {
        return new RestMatchPatternNodeModifier(this);
    }

    public static class RestMatchPatternNodeModifier {
        private final RestMatchPatternNode oldNode;
        private Token ellipsisToken;
        private Token varKeywordToken;
        private SimpleNameReferenceNode variableName;

        public RestMatchPatternNodeModifier(RestMatchPatternNode oldNode) {
            this.oldNode = oldNode;
            this.ellipsisToken = oldNode.ellipsisToken();
            this.varKeywordToken = oldNode.varKeywordToken();
            this.variableName = oldNode.variableName();
        }

        public RestMatchPatternNodeModifier withEllipsisToken(Token ellipsisToken) {
            Objects.requireNonNull(ellipsisToken, "ellipsisToken must not be null");
            this.ellipsisToken = ellipsisToken;
            return this;
        }

        public RestMatchPatternNodeModifier withVarKeywordToken(Token varKeywordToken) {
            Objects.requireNonNull(varKeywordToken, "varKeywordToken must not be null");
            this.varKeywordToken = varKeywordToken;
            return this;
        }

        public RestMatchPatternNodeModifier withVariableName(SimpleNameReferenceNode variableName) {
            Objects.requireNonNull(variableName, "variableName must not be null");
            this.variableName = variableName;
            return this;
        }

        public RestMatchPatternNode apply() {
            return this.oldNode.modify(this.ellipsisToken, this.varKeywordToken, this.variableName);
        }
    }
}

