/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class RollbackStatementNode
extends StatementNode {
    public RollbackStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token rollbackKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Optional<ExpressionNode> expression() {
        return this.optionalChildInBucket(1);
    }

    public Token semicolon() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"rollbackKeyword", "expression", "semicolon"};
    }

    public RollbackStatementNode modify(Token rollbackKeyword, ExpressionNode expression, Token semicolon) {
        if (this.checkForReferenceEquality(rollbackKeyword, expression, semicolon)) {
            return this;
        }
        return NodeFactory.createRollbackStatementNode(rollbackKeyword, expression, semicolon);
    }

    public RollbackStatementNodeModifier modify() {
        return new RollbackStatementNodeModifier(this);
    }

    public static class RollbackStatementNodeModifier {
        private final RollbackStatementNode oldNode;
        private Token rollbackKeyword;
        private ExpressionNode expression;
        private Token semicolon;

        public RollbackStatementNodeModifier(RollbackStatementNode oldNode) {
            this.oldNode = oldNode;
            this.rollbackKeyword = oldNode.rollbackKeyword();
            this.expression = oldNode.expression().orElse(null);
            this.semicolon = oldNode.semicolon();
        }

        public RollbackStatementNodeModifier withRollbackKeyword(Token rollbackKeyword) {
            Objects.requireNonNull(rollbackKeyword, "rollbackKeyword must not be null");
            this.rollbackKeyword = rollbackKeyword;
            return this;
        }

        public RollbackStatementNodeModifier withExpression(ExpressionNode expression) {
            this.expression = expression;
            return this;
        }

        public RollbackStatementNodeModifier withSemicolon(Token semicolon) {
            Objects.requireNonNull(semicolon, "semicolon must not be null");
            this.semicolon = semicolon;
            return this;
        }

        public RollbackStatementNode apply() {
            return this.oldNode.modify(this.rollbackKeyword, this.expression, this.semicolon);
        }
    }
}

