/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ServiceBodyNode
extends NonTerminalNode {
    public ServiceBodyNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBraceToken() {
        return (Token)this.childInBucket(0);
    }

    public NodeList<Node> resources() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBraceToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBraceToken", "resources", "closeBraceToken"};
    }

    public ServiceBodyNode modify(Token openBraceToken, NodeList<Node> resources, Token closeBraceToken) {
        if (this.checkForReferenceEquality(openBraceToken, resources.underlyingListNode(), closeBraceToken)) {
            return this;
        }
        return NodeFactory.createServiceBodyNode(openBraceToken, resources, closeBraceToken);
    }

    public ServiceBodyNodeModifier modify() {
        return new ServiceBodyNodeModifier(this);
    }

    public static class ServiceBodyNodeModifier {
        private final ServiceBodyNode oldNode;
        private Token openBraceToken;
        private NodeList<Node> resources;
        private Token closeBraceToken;

        public ServiceBodyNodeModifier(ServiceBodyNode oldNode) {
            this.oldNode = oldNode;
            this.openBraceToken = oldNode.openBraceToken();
            this.resources = oldNode.resources();
            this.closeBraceToken = oldNode.closeBraceToken();
        }

        public ServiceBodyNodeModifier withOpenBraceToken(Token openBraceToken) {
            Objects.requireNonNull(openBraceToken, "openBraceToken must not be null");
            this.openBraceToken = openBraceToken;
            return this;
        }

        public ServiceBodyNodeModifier withResources(NodeList<Node> resources) {
            Objects.requireNonNull(resources, "resources must not be null");
            this.resources = resources;
            return this;
        }

        public ServiceBodyNodeModifier withCloseBraceToken(Token closeBraceToken) {
            Objects.requireNonNull(closeBraceToken, "closeBraceToken must not be null");
            this.closeBraceToken = closeBraceToken;
            return this;
        }

        public ServiceBodyNode apply() {
            return this.oldNode.modify(this.openBraceToken, this.resources, this.closeBraceToken);
        }
    }
}

