/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ServiceConstructorExpressionNode
extends ExpressionNode {
    public ServiceConstructorExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public Token serviceKeyword() {
        return (Token)this.childInBucket(1);
    }

    public Node serviceBody() {
        return this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "serviceKeyword", "serviceBody"};
    }

    public ServiceConstructorExpressionNode modify(NodeList<AnnotationNode> annotations, Token serviceKeyword, Node serviceBody) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), serviceKeyword, serviceBody)) {
            return this;
        }
        return NodeFactory.createServiceConstructorExpressionNode(annotations, serviceKeyword, serviceBody);
    }

    public ServiceConstructorExpressionNodeModifier modify() {
        return new ServiceConstructorExpressionNodeModifier(this);
    }

    public static class ServiceConstructorExpressionNodeModifier {
        private final ServiceConstructorExpressionNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private Token serviceKeyword;
        private Node serviceBody;

        public ServiceConstructorExpressionNodeModifier(ServiceConstructorExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.serviceKeyword = oldNode.serviceKeyword();
            this.serviceBody = oldNode.serviceBody();
        }

        public ServiceConstructorExpressionNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public ServiceConstructorExpressionNodeModifier withServiceKeyword(Token serviceKeyword) {
            Objects.requireNonNull(serviceKeyword, "serviceKeyword must not be null");
            this.serviceKeyword = serviceKeyword;
            return this;
        }

        public ServiceConstructorExpressionNodeModifier withServiceBody(Node serviceBody) {
            Objects.requireNonNull(serviceBody, "serviceBody must not be null");
            this.serviceBody = serviceBody;
            return this;
        }

        public ServiceConstructorExpressionNode apply() {
            return this.oldNode.modify(this.annotations, this.serviceKeyword, this.serviceBody);
        }
    }
}

