/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ServiceDeclarationNode
extends ModuleMemberDeclarationNode {
    public ServiceDeclarationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<MetadataNode> metadata() {
        return this.optionalChildInBucket(0);
    }

    public NodeList<Token> qualifiers() {
        return new NodeList<Token>((NonTerminalNode)this.childInBucket(1));
    }

    public Token serviceKeyword() {
        return (Token)this.childInBucket(2);
    }

    public Optional<IdentifierToken> serviceName() {
        return this.optionalChildInBucket(3);
    }

    public Token onKeyword() {
        return (Token)this.childInBucket(4);
    }

    public SeparatedNodeList<ExpressionNode> expressions() {
        return new SeparatedNodeList<ExpressionNode>((NonTerminalNode)this.childInBucket(5));
    }

    public Node serviceBody() {
        return this.childInBucket(6);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"metadata", "qualifiers", "serviceKeyword", "serviceName", "onKeyword", "expressions", "serviceBody"};
    }

    public ServiceDeclarationNode modify(MetadataNode metadata, NodeList<Token> qualifiers, Token serviceKeyword, IdentifierToken serviceName, Token onKeyword, SeparatedNodeList<ExpressionNode> expressions, Node serviceBody) {
        if (this.checkForReferenceEquality(metadata, qualifiers.underlyingListNode(), serviceKeyword, serviceName, onKeyword, expressions.underlyingListNode(), serviceBody)) {
            return this;
        }
        return NodeFactory.createServiceDeclarationNode(metadata, qualifiers, serviceKeyword, serviceName, onKeyword, expressions, serviceBody);
    }

    public ServiceDeclarationNodeModifier modify() {
        return new ServiceDeclarationNodeModifier(this);
    }

    public static class ServiceDeclarationNodeModifier {
        private final ServiceDeclarationNode oldNode;
        private MetadataNode metadata;
        private NodeList<Token> qualifiers;
        private Token serviceKeyword;
        private IdentifierToken serviceName;
        private Token onKeyword;
        private SeparatedNodeList<ExpressionNode> expressions;
        private Node serviceBody;

        public ServiceDeclarationNodeModifier(ServiceDeclarationNode oldNode) {
            this.oldNode = oldNode;
            this.metadata = oldNode.metadata().orElse(null);
            this.qualifiers = oldNode.qualifiers();
            this.serviceKeyword = oldNode.serviceKeyword();
            this.serviceName = oldNode.serviceName().orElse(null);
            this.onKeyword = oldNode.onKeyword();
            this.expressions = oldNode.expressions();
            this.serviceBody = oldNode.serviceBody();
        }

        public ServiceDeclarationNodeModifier withMetadata(MetadataNode metadata) {
            this.metadata = metadata;
            return this;
        }

        public ServiceDeclarationNodeModifier withQualifiers(NodeList<Token> qualifiers) {
            Objects.requireNonNull(qualifiers, "qualifiers must not be null");
            this.qualifiers = qualifiers;
            return this;
        }

        public ServiceDeclarationNodeModifier withServiceKeyword(Token serviceKeyword) {
            Objects.requireNonNull(serviceKeyword, "serviceKeyword must not be null");
            this.serviceKeyword = serviceKeyword;
            return this;
        }

        public ServiceDeclarationNodeModifier withServiceName(IdentifierToken serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public ServiceDeclarationNodeModifier withOnKeyword(Token onKeyword) {
            Objects.requireNonNull(onKeyword, "onKeyword must not be null");
            this.onKeyword = onKeyword;
            return this;
        }

        public ServiceDeclarationNodeModifier withExpressions(SeparatedNodeList<ExpressionNode> expressions) {
            Objects.requireNonNull(expressions, "expressions must not be null");
            this.expressions = expressions;
            return this;
        }

        public ServiceDeclarationNodeModifier withServiceBody(Node serviceBody) {
            Objects.requireNonNull(serviceBody, "serviceBody must not be null");
            this.serviceBody = serviceBody;
            return this;
        }

        public ServiceDeclarationNode apply() {
            return this.oldNode.modify(this.metadata, this.qualifiers, this.serviceKeyword, this.serviceName, this.onKeyword, this.expressions, this.serviceBody);
        }
    }
}

