/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class TupleTypeDescriptorNode
extends TypeDescriptorNode {
    public TupleTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracketToken() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<Node> memberTypeDesc() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBracketToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracketToken", "memberTypeDesc", "closeBracketToken"};
    }

    public TupleTypeDescriptorNode modify(Token openBracketToken, SeparatedNodeList<Node> memberTypeDesc, Token closeBracketToken) {
        if (this.checkForReferenceEquality(openBracketToken, memberTypeDesc.underlyingListNode(), closeBracketToken)) {
            return this;
        }
        return NodeFactory.createTupleTypeDescriptorNode(openBracketToken, memberTypeDesc, closeBracketToken);
    }

    public TupleTypeDescriptorNodeModifier modify() {
        return new TupleTypeDescriptorNodeModifier(this);
    }

    public static class TupleTypeDescriptorNodeModifier {
        private final TupleTypeDescriptorNode oldNode;
        private Token openBracketToken;
        private SeparatedNodeList<Node> memberTypeDesc;
        private Token closeBracketToken;

        public TupleTypeDescriptorNodeModifier(TupleTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.openBracketToken = oldNode.openBracketToken();
            this.memberTypeDesc = oldNode.memberTypeDesc();
            this.closeBracketToken = oldNode.closeBracketToken();
        }

        public TupleTypeDescriptorNodeModifier withOpenBracketToken(Token openBracketToken) {
            Objects.requireNonNull(openBracketToken, "openBracketToken must not be null");
            this.openBracketToken = openBracketToken;
            return this;
        }

        public TupleTypeDescriptorNodeModifier withMemberTypeDesc(SeparatedNodeList<Node> memberTypeDesc) {
            Objects.requireNonNull(memberTypeDesc, "memberTypeDesc must not be null");
            this.memberTypeDesc = memberTypeDesc;
            return this;
        }

        public TupleTypeDescriptorNodeModifier withCloseBracketToken(Token closeBracketToken) {
            Objects.requireNonNull(closeBracketToken, "closeBracketToken must not be null");
            this.closeBracketToken = closeBracketToken;
            return this;
        }

        public TupleTypeDescriptorNode apply() {
            return this.oldNode.modify(this.openBracketToken, this.memberTypeDesc, this.closeBracketToken);
        }
    }
}

