/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class TypeTestExpressionNode
extends ExpressionNode {
    public TypeTestExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token isKeyword() {
        return (Token)this.childInBucket(1);
    }

    public Node typeDescriptor() {
        return this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "isKeyword", "typeDescriptor"};
    }

    public TypeTestExpressionNode modify(ExpressionNode expression, Token isKeyword, Node typeDescriptor) {
        if (this.checkForReferenceEquality(expression, isKeyword, typeDescriptor)) {
            return this;
        }
        return NodeFactory.createTypeTestExpressionNode(expression, isKeyword, typeDescriptor);
    }

    public TypeTestExpressionNodeModifier modify() {
        return new TypeTestExpressionNodeModifier(this);
    }

    public static class TypeTestExpressionNodeModifier {
        private final TypeTestExpressionNode oldNode;
        private ExpressionNode expression;
        private Token isKeyword;
        private Node typeDescriptor;

        public TypeTestExpressionNodeModifier(TypeTestExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.isKeyword = oldNode.isKeyword();
            this.typeDescriptor = oldNode.typeDescriptor();
        }

        public TypeTestExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public TypeTestExpressionNodeModifier withIsKeyword(Token isKeyword) {
            Objects.requireNonNull(isKeyword, "isKeyword must not be null");
            this.isKeyword = isKeyword;
            return this;
        }

        public TypeTestExpressionNodeModifier withTypeDescriptor(Node typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public TypeTestExpressionNode apply() {
            return this.oldNode.modify(this.expression, this.isKeyword, this.typeDescriptor);
        }
    }
}

