/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import java.util.Objects;
import java.util.Optional;

public class XmlTypeDescriptorNode
extends TypeDescriptorNode {
    public XmlTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token xmlKeywordToken() {
        return (Token)this.childInBucket(0);
    }

    public Optional<TypeParameterNode> xmlTypeParamsNode() {
        return this.optionalChildInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"xmlKeywordToken", "xmlTypeParamsNode"};
    }

    public XmlTypeDescriptorNode modify(Token xmlKeywordToken, TypeParameterNode xmlTypeParamsNode) {
        if (this.checkForReferenceEquality(xmlKeywordToken, xmlTypeParamsNode)) {
            return this;
        }
        return NodeFactory.createXmlTypeDescriptorNode(xmlKeywordToken, xmlTypeParamsNode);
    }

    public XmlTypeDescriptorNodeModifier modify() {
        return new XmlTypeDescriptorNodeModifier(this);
    }

    public static class XmlTypeDescriptorNodeModifier {
        private final XmlTypeDescriptorNode oldNode;
        private Token xmlKeywordToken;
        private TypeParameterNode xmlTypeParamsNode;

        public XmlTypeDescriptorNodeModifier(XmlTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.xmlKeywordToken = oldNode.xmlKeywordToken();
            this.xmlTypeParamsNode = oldNode.xmlTypeParamsNode().orElse(null);
        }

        public XmlTypeDescriptorNodeModifier withXmlKeywordToken(Token xmlKeywordToken) {
            Objects.requireNonNull(xmlKeywordToken, "xmlKeywordToken must not be null");
            this.xmlKeywordToken = xmlKeywordToken;
            return this;
        }

        public XmlTypeDescriptorNodeModifier withXmlTypeParamsNode(TypeParameterNode xmlTypeParamsNode) {
            this.xmlTypeParamsNode = xmlTypeParamsNode;
            return this;
        }

        public XmlTypeDescriptorNode apply() {
            return this.oldNode.modify(this.xmlKeywordToken, this.xmlTypeParamsNode);
        }
    }
}

