/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class Bootstrap {
    private final PackageResolver packageResolver;
    private boolean langLibLoaded = false;

    public Bootstrap(PackageResolver packageResolver) {
        this.packageResolver = packageResolver;
    }

    void loadLangLib(CompilerContext compilerContext, PackageID langLib) {
        if (this.langLibLoaded) {
            return;
        }
        this.langLibLoaded = true;
        if (langLib.equals(PackageID.ANNOTATIONS)) {
            return;
        }
        SymbolResolver symResolver = SymbolResolver.getInstance(compilerContext);
        SymbolTable symbolTable = SymbolTable.getInstance(compilerContext);
        symbolTable.langAnnotationModuleSymbol = this.loadLangLibFromBalr(PackageID.ANNOTATIONS, compilerContext);
        symResolver.reloadErrorAndDependentTypes();
        if (langLib.equals(PackageID.JAVA)) {
            return;
        }
        symbolTable.langJavaModuleSymbol = this.loadLangLibFromBalr(PackageID.JAVA, compilerContext);
        if (langLib.equals(PackageID.INTERNAL)) {
            return;
        }
        symbolTable.langInternalModuleSymbol = this.loadLangLibFromBalr(PackageID.INTERNAL, compilerContext);
        if (langLib.equals(PackageID.QUERY)) {
            symbolTable.langArrayModuleSymbol = this.loadLangLibFromBalr(PackageID.ARRAY, compilerContext);
            symbolTable.langMapModuleSymbol = this.loadLangLibFromBalr(PackageID.MAP, compilerContext);
            symbolTable.langStringModuleSymbol = this.loadLangLibFromBalr(PackageID.STRING, compilerContext);
            symbolTable.langValueModuleSymbol = this.loadLangLibFromBalr(PackageID.VALUE, compilerContext);
            symbolTable.langXmlModuleSymbol = this.loadLangLibFromBalr(PackageID.XML, compilerContext);
            symbolTable.langTableModuleSymbol = this.loadLangLibFromBalr(PackageID.TABLE, compilerContext);
            symbolTable.langStreamModuleSymbol = this.loadLangLibFromBalr(PackageID.STREAM, compilerContext);
        }
        if (langLib.equals(PackageID.TRANSACTION)) {
            symbolTable.langArrayModuleSymbol = this.loadLangLibFromBalr(PackageID.ARRAY, compilerContext);
            symbolTable.langMapModuleSymbol = this.loadLangLibFromBalr(PackageID.MAP, compilerContext);
            symbolTable.langStringModuleSymbol = this.loadLangLibFromBalr(PackageID.STRING, compilerContext);
            symbolTable.langValueModuleSymbol = this.loadLangLibFromBalr(PackageID.VALUE, compilerContext);
            symbolTable.langErrorModuleSymbol = this.loadLangLibFromBalr(PackageID.ERROR, compilerContext);
        }
        symResolver.reloadIntRangeType();
    }

    public void loadLangLibSymbols(CompilerContext compilerContext) {
        SymbolResolver symResolver = SymbolResolver.getInstance(compilerContext);
        SymbolTable symbolTable = SymbolTable.getInstance(compilerContext);
        symbolTable.langAnnotationModuleSymbol = this.loadLangLibFromBalr(PackageID.ANNOTATIONS, compilerContext);
        symbolTable.langJavaModuleSymbol = this.loadLangLibFromBalr(PackageID.JAVA, compilerContext);
        symbolTable.langInternalModuleSymbol = this.loadLangLibFromBalr(PackageID.INTERNAL, compilerContext);
        symResolver.reloadErrorAndDependentTypes();
        symResolver.reloadIntRangeType();
        symbolTable.langArrayModuleSymbol = this.loadLangLibFromBalr(PackageID.ARRAY, compilerContext);
        symbolTable.langDecimalModuleSymbol = this.loadLangLibFromBalr(PackageID.DECIMAL, compilerContext);
        symbolTable.langErrorModuleSymbol = this.loadLangLibFromBalr(PackageID.ERROR, compilerContext);
        symbolTable.langFloatModuleSymbol = this.loadLangLibFromBalr(PackageID.FLOAT, compilerContext);
        symbolTable.langFutureModuleSymbol = this.loadLangLibFromBalr(PackageID.FUTURE, compilerContext);
        symbolTable.langIntModuleSymbol = this.loadLangLibFromBalr(PackageID.INT, compilerContext);
        symbolTable.langMapModuleSymbol = this.loadLangLibFromBalr(PackageID.MAP, compilerContext);
        symbolTable.langObjectModuleSymbol = this.loadLangLibFromBalr(PackageID.OBJECT, compilerContext);
        symResolver.loadRawTemplateType();
        symbolTable.langStreamModuleSymbol = this.loadLangLibFromBalr(PackageID.STREAM, compilerContext);
        symbolTable.langTableModuleSymbol = this.loadLangLibFromBalr(PackageID.TABLE, compilerContext);
        symbolTable.langStringModuleSymbol = this.loadLangLibFromBalr(PackageID.STRING, compilerContext);
        symbolTable.langTypedescModuleSymbol = this.loadLangLibFromBalr(PackageID.TYPEDESC, compilerContext);
        symbolTable.langValueModuleSymbol = this.loadLangLibFromBalr(PackageID.VALUE, compilerContext);
        symbolTable.langXmlModuleSymbol = this.loadLangLibFromBalr(PackageID.XML, compilerContext);
        symbolTable.langBooleanModuleSymbol = this.loadLangLibFromBalr(PackageID.BOOLEAN, compilerContext);
        symbolTable.langQueryModuleSymbol = this.loadLangLibFromBalr(PackageID.QUERY, compilerContext);
        symbolTable.langTransactionModuleSymbol = this.loadLangLibFromBalr(PackageID.TRANSACTION, compilerContext);
        symbolTable.loadPredeclaredModules();
    }

    private BPackageSymbol loadLangLibFromBalr(PackageID langLib, CompilerContext compilerContext) {
        ResolutionRequest packageLoadRequest = this.toPackageLoadRequest(langLib);
        this.loadLangLibFromBalr(packageLoadRequest);
        return this.getSymbolFromCache(compilerContext, langLib);
    }

    private void loadLangLibFromBalr(ResolutionRequest packageLoadRequest) {
        List<ResolutionResponse> resolutionResponses = this.packageResolver.resolvePackages(Collections.singletonList(packageLoadRequest));
        resolutionResponses.forEach(pkgLoadResp -> {
            Package pkg = pkgLoadResp.resolvedPackage();
            PackageCompilation compilation = pkg.getCompilation();
            if (compilation.diagnosticResult().hasErrors()) {
                throw new ProjectException("Error while bootstrapping :" + pkg.packageId().toString() + " diagnostics: " + compilation.diagnosticResult());
            }
        });
    }

    private ResolutionRequest toPackageLoadRequest(PackageID packageID) {
        PackageOrg pkgOrg = PackageOrg.from(packageID.orgName.getValue());
        PackageName pkgName = PackageName.from(packageID.name.getValue());
        PackageVersion pkgVersion = PackageVersion.from(packageID.getPackageVersion().toString());
        PackageDescriptor packageDescriptor = PackageDescriptor.from(pkgOrg, pkgName, pkgVersion);
        return ResolutionRequest.from(packageDescriptor, PackageDependencyScope.DEFAULT);
    }

    private BPackageSymbol getSymbolFromCache(CompilerContext context, PackageID packageID) {
        PackageCache pkgCache = PackageCache.getInstance(context);
        BLangPackage bLangPackage = pkgCache.get(packageID);
        if (bLangPackage != null) {
            return bLangPackage.symbol;
        }
        return pkgCache.getSymbol(packageID);
    }
}

