/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.CompilationOptions;
import java.util.Objects;

public class BuildOptions {
    private Boolean testReport;
    private Boolean codeCoverage;
    private CompilationOptions compilationOptions;

    BuildOptions(Boolean testReport, Boolean codeCoverage, CompilationOptions compilationOptions) {
        this.testReport = testReport;
        this.codeCoverage = codeCoverage;
        this.compilationOptions = compilationOptions;
    }

    public boolean testReport() {
        return this.toBooleanDefaultIfNull(this.testReport);
    }

    public boolean codeCoverage() {
        return this.toBooleanDefaultIfNull(this.codeCoverage);
    }

    public boolean skipTests() {
        return this.compilationOptions.skipTests();
    }

    public boolean offlineBuild() {
        return this.compilationOptions.offlineBuild();
    }

    public boolean experimental() {
        return this.compilationOptions.experimental();
    }

    public boolean observabilityIncluded() {
        return this.compilationOptions.observabilityIncluded();
    }

    CompilationOptions compilationOptions() {
        return this.compilationOptions;
    }

    public BuildOptions acceptTheirs(BuildOptions theirOptions) {
        this.codeCoverage = Objects.requireNonNullElseGet(theirOptions.codeCoverage, () -> this.toBooleanDefaultIfNull(this.codeCoverage));
        this.testReport = Objects.requireNonNullElseGet(theirOptions.testReport, () -> this.toBooleanDefaultIfNull(this.testReport));
        this.compilationOptions = this.compilationOptions.acceptTheirs(theirOptions.compilationOptions());
        return this;
    }

    private boolean toBooleanDefaultIfNull(Boolean bool) {
        if (bool == null) {
            return false;
        }
        return bool;
    }

    public static enum OptionName {
        TEST_REPORT("testReport"),
        CODE_COVERAGE("codeCoverage"),
        B7A_CONFIG_FILE("b7aConfigFile");

        private String name;

        private OptionName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

