/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import java.util.Objects;

class CompilationOptions {
    private Boolean skipTests;
    private Boolean offlineBuild;
    private Boolean experimental;
    private Boolean observabilityIncluded;

    CompilationOptions(Boolean skipTests, Boolean offlineBuild, Boolean experimental, Boolean observabilityIncluded) {
        this.skipTests = skipTests;
        this.offlineBuild = offlineBuild;
        this.experimental = experimental;
        this.observabilityIncluded = observabilityIncluded;
    }

    boolean skipTests() {
        return this.toBooleanDefaultIfNull(this.skipTests);
    }

    boolean offlineBuild() {
        return this.toBooleanDefaultIfNull(this.offlineBuild);
    }

    boolean experimental() {
        return this.toBooleanDefaultIfNull(this.experimental);
    }

    boolean observabilityIncluded() {
        return this.toBooleanDefaultIfNull(this.observabilityIncluded);
    }

    CompilationOptions acceptTheirs(CompilationOptions theirOptions) {
        this.skipTests = Objects.requireNonNullElseGet(theirOptions.skipTests, () -> this.toBooleanDefaultIfNull(this.skipTests));
        this.offlineBuild = Objects.requireNonNullElseGet(theirOptions.offlineBuild, () -> this.toBooleanDefaultIfNull(this.offlineBuild));
        this.experimental = Objects.requireNonNullElseGet(theirOptions.experimental, () -> this.toBooleanDefaultIfNull(this.experimental));
        this.observabilityIncluded = Objects.requireNonNullElseGet(theirOptions.observabilityIncluded, () -> this.toBooleanDefaultIfNull(this.observabilityIncluded));
        return this;
    }

    private boolean toBooleanDefaultIfNull(Boolean bool) {
        if (bool == null) {
            return false;
        }
        return bool;
    }
}

