/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyGraph<T> {
    private static final DependencyGraph EMPTY_GRAPH = new DependencyGraph(new HashMap());
    private final Map<T, Set<T>> dependencies;
    private List<T> topologicallySortedNodes;

    public static <T> DependencyGraph<T> emptyGraph() {
        return EMPTY_GRAPH;
    }

    public static <T> DependencyGraph<T> from(Map<T, Set<T>> dependencies) {
        if (dependencies.isEmpty()) {
            return EMPTY_GRAPH;
        }
        return new DependencyGraph<T>(dependencies);
    }

    private DependencyGraph(Map<T, Set<T>> dependencies) {
        this.dependencies = Collections.unmodifiableMap(dependencies);
    }

    public void findCycles() {
    }

    public DependencyGraph<T> add(T node) {
        HashMap<T, Set<T>> newDependencies = new HashMap<T, Set<T>>(this.dependencies);
        newDependencies.put(node, new HashSet());
        return new DependencyGraph<T>(newDependencies);
    }

    public DependencyGraph<T> addAll(Collection<T> nodes) {
        throw new UnsupportedOperationException();
    }

    public DependencyGraph<T> addDependencies(T dependent, Collection<T> dependencies) {
        throw new UnsupportedOperationException();
    }

    public Collection<T> getNodes() {
        return this.dependencies.keySet();
    }

    public Collection<T> getDirectDependents(T node) {
        throw new UnsupportedOperationException();
    }

    public Collection<T> getDirectDependencies(T node) {
        Set<T> deps = this.dependencies.get(node);
        if (deps == null) {
            return Collections.emptySet();
        }
        return deps;
    }

    public boolean contains(T node) {
        return this.dependencies.containsKey(node);
    }

    public List<T> toTopologicallySortedList() {
        if (this.topologicallySortedNodes != null) {
            return this.topologicallySortedNodes;
        }
        ArrayList sorted = new ArrayList();
        this.sortTopologically(this.dependencies.keySet(), new HashSet(), sorted);
        this.topologicallySortedNodes = Collections.unmodifiableList(sorted);
        return this.topologicallySortedNodes;
    }

    public boolean isEmpty() {
        return this == EMPTY_GRAPH;
    }

    private void sortTopologically(Collection<T> nodesToSort, Set<T> visited, List<T> sorted) {
        for (T node : nodesToSort) {
            if (visited.contains(node)) continue;
            visited.add(node);
            this.sortTopologically((Collection)this.dependencies.get(node), visited, sorted);
            sorted.add(node);
        }
    }

    public static class DependencyGraphBuilder<T> {
        private final Map<T, Set<T>> dependenciesMap;

        private DependencyGraphBuilder(Map<T, Set<T>> dependencies) {
            this.dependenciesMap = dependencies;
        }

        public static <T> DependencyGraphBuilder<T> getBuilder() {
            return new DependencyGraphBuilder(new HashMap());
        }

        public DependencyGraphBuilder<T> add(T node) {
            if (!this.dependenciesMap.containsKey(node)) {
                this.dependenciesMap.put(node, new HashSet());
            }
            return this;
        }

        public DependencyGraphBuilder<T> addDependency(T dependent, T dependency) {
            this.getCurrentDependencies(dependent).add(dependency);
            return this.add(dependency);
        }

        public DependencyGraphBuilder<T> addDependencies(T dependent, Collection<T> dependencies) {
            this.getCurrentDependencies(dependent).addAll(dependencies);
            dependencies.forEach(this::add);
            return this;
        }

        public DependencyGraphBuilder<T> mergeGraph(DependencyGraph<T> theirGraph) {
            Map<T, Set<T>> ourDependenciesMap = this.dependenciesMap;
            for (Map.Entry theirDependencyEntry : theirGraph.dependencies.entrySet()) {
                if (ourDependenciesMap.containsKey(theirDependencyEntry.getKey())) {
                    Set<T> ourCurrentDependencies = ourDependenciesMap.get(theirDependencyEntry.getKey());
                    ourCurrentDependencies.addAll(theirDependencyEntry.getValue());
                    continue;
                }
                ourDependenciesMap.put(theirDependencyEntry.getKey(), theirDependencyEntry.getValue());
            }
            return this;
        }

        public DependencyGraph<T> build() {
            return new DependencyGraph<T>(this.dependenciesMap);
        }

        private Set<T> getCurrentDependencies(T dependent) {
            Set<Object> currentDependencies;
            if (this.dependenciesMap.containsKey(dependent)) {
                currentDependencies = this.dependenciesMap.get(dependent);
            } else {
                currentDependencies = new HashSet();
                this.dependenciesMap.put(dependent, currentDependencies);
            }
            return currentDependencies;
        }
    }
}

