/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.Diagnostics;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collection;
import java.util.Collections;

public abstract class DiagnosticResult {
    protected final Collection<Diagnostic> allDiagnostics;
    protected Collection<Diagnostic> errors;
    protected Collection<Diagnostic> warnings;

    protected DiagnosticResult(Collection<Diagnostic> allDiagnostics) {
        this.allDiagnostics = Collections.unmodifiableCollection(allDiagnostics);
    }

    public Collection<Diagnostic> diagnostics() {
        return this.allDiagnostics;
    }

    public Collection<Diagnostic> errors() {
        return this.getErrors(this.allDiagnostics);
    }

    public Collection<Diagnostic> warnings() {
        return this.getWarnings(this.allDiagnostics);
    }

    public int diagnosticCount() {
        return this.allDiagnostics.size();
    }

    public int errorCount() {
        return this.getErrors(this.allDiagnostics).size();
    }

    public int warningCount() {
        return this.getWarnings(this.allDiagnostics).size();
    }

    public boolean hasErrors() {
        return !this.getErrors(this.allDiagnostics).isEmpty();
    }

    public boolean hasWarnings() {
        return !this.getWarnings(this.allDiagnostics).isEmpty();
    }

    private Collection<Diagnostic> getErrors(Collection<Diagnostic> diagnostics) {
        if (this.errors != null) {
            return this.errors;
        }
        this.errors = Diagnostics.filterErrors(diagnostics);
        return this.errors;
    }

    private Collection<Diagnostic> getWarnings(Collection<Diagnostic> diagnostics) {
        if (this.warnings != null) {
            return this.warnings;
        }
        this.warnings = Diagnostics.filterWarnings(diagnostics);
        return this.warnings;
    }
}

