/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.Collection;
import java.util.stream.Collectors;

public class Diagnostics {
    public static Collection<Diagnostic> filterErrors(Collection<Diagnostic> diagnostics) {
        return Diagnostics.filterDiagnostics(diagnostics, DiagnosticSeverity.ERROR);
    }

    public static boolean hasErrors(Collection<Diagnostic> diagnostics) {
        return Diagnostics.hasDiagnosticsWithSeverity(diagnostics, DiagnosticSeverity.ERROR);
    }

    public static Collection<Diagnostic> filterWarnings(Collection<Diagnostic> diagnostics) {
        return Diagnostics.filterDiagnostics(diagnostics, DiagnosticSeverity.WARNING);
    }

    public static boolean hasWarnings(Collection<Diagnostic> diagnostics) {
        return Diagnostics.hasDiagnosticsWithSeverity(diagnostics, DiagnosticSeverity.WARNING);
    }

    private static Collection<Diagnostic> filterDiagnostics(Collection<Diagnostic> diagnostics, DiagnosticSeverity severity) {
        return diagnostics.stream().filter(diagnostic -> diagnostic.diagnosticInfo().severity() == severity).collect(Collectors.toList());
    }

    private static boolean hasDiagnosticsWithSeverity(Collection<Diagnostic> diagnostics, DiagnosticSeverity severity) {
        return diagnostics.stream().anyMatch(diagnostic -> diagnostic.diagnosticInfo().severity() == severity);
    }
}

