/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.environment.ModuleLoadRequest;
import io.ballerina.projects.internal.TransactionImportValidator;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

class DocumentContext {
    private static final String IDENTIFIER_LITERAL_PREFIX = "'";
    private SyntaxTree syntaxTree;
    private TextDocument textDocument;
    private Set<ModuleLoadRequest> moduleLoadRequests;
    private BLangCompilationUnit compilationUnit;
    private NodeCloner nodeCloner;
    private DocumentId documentId;
    private String name;
    private String content;

    private DocumentContext(DocumentId documentId, String name, String content) {
        this.documentId = documentId;
        this.name = name;
        this.content = content;
    }

    static DocumentContext from(DocumentConfig documentConfig) {
        return new DocumentContext(documentConfig.documentId(), documentConfig.name(), documentConfig.content());
    }

    DocumentId documentId() {
        return this.documentId;
    }

    String name() {
        return this.name;
    }

    void parse() {
        if (this.syntaxTree != null) {
            return;
        }
        this.syntaxTree = SyntaxTree.from(this.textDocument(), this.name);
    }

    SyntaxTree syntaxTree() {
        this.parse();
        return this.syntaxTree;
    }

    TextDocument textDocument() {
        if (this.textDocument == null) {
            this.textDocument = TextDocuments.from(this.content);
        }
        return this.textDocument;
    }

    BLangCompilationUnit compilationUnit(CompilerContext compilerContext, PackageID pkgID) {
        this.nodeCloner = NodeCloner.getInstance(compilerContext);
        if (this.compilationUnit != null) {
            return this.nodeCloner.clone(this.compilationUnit);
        }
        BLangDiagnosticLog dlog = BLangDiagnosticLog.getInstance(compilerContext);
        SyntaxTree syntaxTree = this.syntaxTree();
        this.reportSyntaxDiagnostics(pkgID, syntaxTree, dlog);
        BLangNodeTransformer bLangNodeTransformer = new BLangNodeTransformer(compilerContext, pkgID, this.name);
        this.compilationUnit = (BLangCompilationUnit)bLangNodeTransformer.accept((Node)syntaxTree.rootNode()).get(0);
        return this.nodeCloner.clone(this.compilationUnit);
    }

    Set<ModuleLoadRequest> moduleLoadRequests(PackageDependencyScope scope) {
        if (this.moduleLoadRequests != null) {
            return this.moduleLoadRequests;
        }
        this.moduleLoadRequests = this.getModuleLoadRequests(scope);
        return this.moduleLoadRequests;
    }

    private Set<ModuleLoadRequest> getModuleLoadRequests(PackageDependencyScope scope) {
        LinkedHashSet<ModuleLoadRequest> moduleLoadRequests = new LinkedHashSet<ModuleLoadRequest>();
        ModulePartNode modulePartNode = (ModulePartNode)this.syntaxTree().rootNode();
        for (ImportDeclarationNode importDcl : modulePartNode.imports()) {
            moduleLoadRequests.add(this.getModuleLoadRequest(importDcl, scope));
        }
        TransactionImportValidator trxImportValidator = new TransactionImportValidator();
        if (trxImportValidator.shouldImportTransactionPackage(modulePartNode)) {
            PackageName packageName = PackageName.from(Names.TRANSACTION.value);
            ModuleLoadRequest ballerinaiLoadReq = new ModuleLoadRequest(PackageOrg.from(Names.BALLERINA_INTERNAL_ORG.value), packageName, ModuleName.from(packageName), null, scope);
            moduleLoadRequests.add(ballerinaiLoadReq);
        }
        return moduleLoadRequests;
    }

    private ModuleLoadRequest getModuleLoadRequest(ImportDeclarationNode importDcl, PackageDependencyScope scope) {
        int moduleNamePartStartIndex;
        PackageName packageName;
        PackageOrg orgName = importDcl.orgName().map(orgNameNode -> PackageOrg.from(orgNameNode.orgName().text())).orElse(null);
        SeparatedNodeList<IdentifierToken> identifierTokenList = importDcl.moduleName();
        String firstModuleNamePart = this.handleQuotedIdentifier(identifierTokenList.get(0).text());
        if (PackageOrg.BALLERINA_ORG.equals(orgName) && "lang".equals(firstModuleNamePart)) {
            String secondModuleNamePart = this.handleQuotedIdentifier(identifierTokenList.get(1).text());
            packageName = PackageName.from(firstModuleNamePart + "." + secondModuleNamePart);
            moduleNamePartStartIndex = 2;
        } else {
            packageName = PackageName.from(firstModuleNamePart);
            moduleNamePartStartIndex = 1;
        }
        StringJoiner stringJoiner = new StringJoiner(".");
        for (int i = moduleNamePartStartIndex; i < identifierTokenList.size(); ++i) {
            stringJoiner.add(this.handleQuotedIdentifier(identifierTokenList.get(i).text()));
        }
        String moduleNamePart = stringJoiner.toString();
        ModuleName moduleName = ModuleName.from(packageName, moduleNamePart.isEmpty() ? null : moduleNamePart);
        return new ModuleLoadRequest(orgName, packageName, moduleName, null, scope);
    }

    private String handleQuotedIdentifier(String identifier) {
        if (identifier.startsWith(IDENTIFIER_LITERAL_PREFIX)) {
            return identifier.substring(1);
        }
        return identifier;
    }

    private void reportSyntaxDiagnostics(PackageID pkgID, SyntaxTree tree, BLangDiagnosticLog dlog) {
        for (Diagnostic syntaxDiagnostic : tree.diagnostics()) {
            dlog.logDiagnostic(pkgID, syntaxDiagnostic);
        }
    }
}

