/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.impl.BallerinaSemanticModel;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class ModuleCompilation {
    private final ModuleContext moduleContext;
    private final PackageContext packageContext;
    private final PackageCache packageCache;
    private final CompilerContext compilerContext;
    private final DependencyGraph<ModuleId> dependencyGraph;
    private DiagnosticResult diagnosticResult;

    ModuleCompilation(PackageContext packageContext, ModuleContext moduleContext) {
        this.packageContext = packageContext;
        this.moduleContext = moduleContext;
        packageContext.getResolution();
        ProjectEnvironment projectEnvContext = packageContext.project().projectEnvironmentContext();
        this.packageCache = projectEnvContext.getService(PackageCache.class);
        this.compilerContext = projectEnvContext.getService(CompilerContext.class);
        this.dependencyGraph = this.buildDependencyGraph();
        this.compile();
    }

    private DependencyGraph<ModuleId> buildDependencyGraph() {
        HashMap<ModuleId, Set<ModuleId>> dependencyIdMap = new HashMap<ModuleId, Set<ModuleId>>();
        this.addModuleDependencies(this.moduleContext.moduleId(), dependencyIdMap);
        return DependencyGraph.from(dependencyIdMap);
    }

    private void addModuleDependencies(ModuleId moduleId, Map<ModuleId, Set<ModuleId>> dependencyIdMap) {
        Package pkg = this.packageCache.getPackageOrThrow(moduleId.packageId());
        HashSet<ModuleId> directDependencies = new HashSet<ModuleId>(pkg.moduleDependencyGraph().getDirectDependencies(moduleId));
        ModuleContext moduleCtx = pkg.packageContext().moduleContext(moduleId);
        for (ModuleDependency moduleDependency : moduleCtx.dependencies()) {
            PackageId dependentPkgId = moduleDependency.packageDependency().packageId();
            if (dependentPkgId == pkg.packageId()) continue;
            ModuleId dependentModuleId = moduleDependency.moduleId();
            directDependencies.add(dependentModuleId);
            this.addModuleDependencies(dependentModuleId, dependencyIdMap);
        }
        dependencyIdMap.put(moduleId, new HashSet<ModuleId>(directDependencies));
        for (ModuleId depModuleId : directDependencies) {
            this.addModuleDependencies(depModuleId, dependencyIdMap);
        }
    }

    private void compile() {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        List<ModuleId> sortedModuleIds = this.dependencyGraph.toTopologicallySortedList();
        for (ModuleId sortedModuleId : sortedModuleIds) {
            Package pkg = this.packageCache.getPackageOrThrow(sortedModuleId.packageId());
            ModuleContext moduleContext = pkg.module(sortedModuleId).moduleContext();
            moduleContext.compile(this.compilerContext);
            diagnostics.addAll(moduleContext.diagnostics());
        }
        this.diagnosticResult = new DefaultDiagnosticResult(diagnostics);
    }

    public SemanticModel getSemanticModel() {
        return new BallerinaSemanticModel(this.moduleContext.bLangPackage(), this.compilerContext);
    }

    public DiagnosticResult diagnostics() {
        return this.diagnosticResult;
    }
}

