/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import java.util.Objects;

public class ModuleName {
    private static final String MODULE_NAME_SEPARATOR = ".";
    private final PackageName packageName;
    private final String moduleNamePart;

    private ModuleName(PackageName packageName, String moduleNamePart) {
        this.packageName = packageName;
        this.moduleNamePart = moduleNamePart;
    }

    public static ModuleName from(PackageName packageName) {
        return new ModuleName(packageName, null);
    }

    public static ModuleName from(PackageName packageName, String moduleNamePart) {
        if (moduleNamePart != null && moduleNamePart.isEmpty()) {
            throw new IllegalArgumentException("moduleNamePart should be a non-empty string or null");
        }
        return new ModuleName(packageName, moduleNamePart);
    }

    public static ModuleName from(String moduleNameStr, PackageOrg packageOrg) {
        int indexOfModuleNameSeparator = moduleNameStr.indexOf(MODULE_NAME_SEPARATOR);
        if (indexOfModuleNameSeparator == -1) {
            return ModuleName.from(PackageName.from(moduleNameStr));
        }
        String langLibModulePrefix = "lang.";
        if (packageOrg.isBallerinaOrg() && moduleNameStr.startsWith(langLibModulePrefix)) {
            return ModuleName.from(PackageName.from(moduleNameStr));
        }
        PackageName packageName = PackageName.from(moduleNameStr.substring(0, indexOfModuleNameSeparator));
        String moduleNamePart = moduleNameStr.substring(indexOfModuleNameSeparator + 1);
        return ModuleName.from(packageName, moduleNamePart);
    }

    public PackageName packageName() {
        return this.packageName;
    }

    public String moduleNamePart() {
        return this.moduleNamePart;
    }

    public boolean isDefaultModuleName() {
        return this.moduleNamePart == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleName that = (ModuleName)o;
        return this.packageName.equals(that.packageName) && Objects.equals(this.moduleNamePart, that.moduleNamePart);
    }

    public int hashCode() {
        return Objects.hash(this.packageName, this.moduleNamePart);
    }

    public String toString() {
        return this.packageName + (String)(this.moduleNamePart != null ? MODULE_NAME_SEPARATOR + this.moduleNamePart : "");
    }
}

