/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleConfig;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageDependency;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class Package {
    private final Project project;
    private final PackageContext packageContext;
    private final Map<ModuleId, Module> moduleMap;
    private final Function<ModuleId, Module> populateModuleFunc;

    private Package(PackageContext packageContext, Project project) {
        this.packageContext = packageContext;
        this.project = project;
        this.moduleMap = new ConcurrentHashMap<ModuleId, Module>();
        this.populateModuleFunc = moduleId -> Module.from(this.packageContext.moduleContext((ModuleId)moduleId), this);
    }

    static Package from(Project project, PackageConfig packageConfig, CompilationOptions compilationOptions) {
        PackageContext packageContext = PackageContext.from(project, packageConfig, compilationOptions);
        return new Package(packageContext, project);
    }

    PackageContext packageContext() {
        return this.packageContext;
    }

    public Project project() {
        return this.project;
    }

    public PackageId packageId() {
        return this.packageContext.packageId();
    }

    public PackageName packageName() {
        return this.packageContext.packageName();
    }

    public PackageOrg packageOrg() {
        return this.packageContext.packageOrg();
    }

    public PackageVersion packageVersion() {
        return this.packageContext.packageVersion();
    }

    public PackageDescriptor descriptor() {
        return this.packageContext.descriptor();
    }

    public PackageManifest manifest() {
        return this.packageContext.manifest();
    }

    public Collection<ModuleId> moduleIds() {
        return this.packageContext.moduleIds();
    }

    public Iterable<Module> modules() {
        ArrayList<Module> moduleList = new ArrayList<Module>();
        for (ModuleId moduleId : this.packageContext.moduleIds()) {
            moduleList.add(this.module(moduleId));
        }
        return new ModuleIterable(moduleList);
    }

    public Module module(ModuleId moduleId) {
        return this.moduleMap.computeIfAbsent(moduleId, this.populateModuleFunc);
    }

    public Module module(ModuleName moduleName) {
        for (Module module : this.moduleMap.values()) {
            if (!module.moduleName().equals(moduleName)) continue;
            return module;
        }
        ModuleContext moduleContext = this.packageContext.moduleContext(moduleName);
        if (moduleContext != null) {
            return this.module(moduleContext.moduleId());
        }
        return null;
    }

    public boolean containsModule(ModuleId moduleId) {
        return this.moduleMap.containsKey(moduleId);
    }

    public Module getDefaultModule() {
        return this.module(this.packageContext.defaultModuleContext().moduleId());
    }

    public PackageCompilation getCompilation() {
        return this.packageContext.getPackageCompilation();
    }

    public PackageResolution getResolution() {
        return this.packageContext.getResolution();
    }

    public DependencyGraph<ModuleId> moduleDependencyGraph() {
        return this.packageContext.moduleDependencyGraph();
    }

    public Collection<PackageDependency> packageDependencies() {
        return this.packageContext.packageDependencies();
    }

    public CompilationOptions compilationOptions() {
        return this.packageContext.compilationOptions();
    }

    public Optional<BallerinaToml> ballerinaToml() {
        return this.packageContext.ballerinaToml();
    }

    public Modifier modify() {
        return new Modifier(this);
    }

    public static class Modifier {
        private PackageId packageId;
        private PackageManifest packageManifest;
        private BallerinaToml ballerinaToml;
        private Map<ModuleId, ModuleContext> moduleContextMap;
        private Project project;
        private final DependencyGraph<PackageDescriptor> pkgDescDependencyGraph;
        private CompilationOptions compilationOptions;

        public Modifier(Package oldPackage) {
            this.packageId = oldPackage.packageId();
            this.packageManifest = oldPackage.manifest();
            this.ballerinaToml = oldPackage.ballerinaToml().orElse(null);
            this.moduleContextMap = this.copyModules(oldPackage);
            this.project = oldPackage.project;
            this.pkgDescDependencyGraph = oldPackage.packageContext().dependencyGraph();
            this.compilationOptions = oldPackage.compilationOptions();
        }

        Modifier updateModule(ModuleContext newModuleContext) {
            this.moduleContextMap.put(newModuleContext.moduleId(), newModuleContext);
            return this;
        }

        public Modifier addModule(ModuleConfig moduleConfig) {
            ModuleContext newModuleContext = ModuleContext.from(this.project, moduleConfig);
            this.moduleContextMap.put(newModuleContext.moduleId(), newModuleContext);
            return this;
        }

        public Modifier removeModule(ModuleId moduleId) {
            this.moduleContextMap.remove(moduleId);
            return this;
        }

        public Package apply() {
            return this.createNewPackage();
        }

        private Map<ModuleId, ModuleContext> copyModules(Package oldPackage) {
            HashMap<ModuleId, ModuleContext> moduleContextMap = new HashMap<ModuleId, ModuleContext>();
            for (ModuleId moduleId : oldPackage.packageContext.moduleIds()) {
                moduleContextMap.put(moduleId, oldPackage.packageContext.moduleContext(moduleId));
            }
            return moduleContextMap;
        }

        private Package createNewPackage() {
            PackageContext newPackageContext = new PackageContext(this.project, this.packageId, this.packageManifest, this.ballerinaToml, this.compilationOptions, this.moduleContextMap, this.pkgDescDependencyGraph);
            this.project.setCurrentPackage(new Package(newPackageContext, this.project));
            return this.project.currentPackage();
        }
    }

    private static class ModuleIterable
    implements Iterable {
        private final Collection<Module> moduleList;

        public ModuleIterable(Collection<Module> moduleList) {
            this.moduleList = moduleList;
        }

        public Iterator<Module> iterator() {
            return this.moduleList.iterator();
        }

        public Spliterator spliterator() {
            return this.moduleList.spliterator();
        }
    }
}

