/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.impl.BallerinaSemanticModel;
import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.ModuleCompilationState;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.ballerinalang.compiler.CompilerOptionName;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class PackageCompilation {
    private final PackageContext rootPackageContext;
    private final PackageResolution packageResolution;
    private final CompilerContext compilerContext;
    private final Map<CompilerBackend.TargetPlatform, CompilerBackend> compilerBackends;
    private DiagnosticResult diagnosticResult;
    private boolean compiled;

    private PackageCompilation(PackageContext rootPackageContext, PackageResolution packageResolution) {
        this.rootPackageContext = rootPackageContext;
        this.packageResolution = packageResolution;
        ProjectEnvironment projectEnvContext = rootPackageContext.project().projectEnvironmentContext();
        this.compilerContext = projectEnvContext.getService(CompilerContext.class);
        this.setCompilerOptions(rootPackageContext.compilationOptions());
        this.compilerBackends = new HashMap<CompilerBackend.TargetPlatform, CompilerBackend>(1);
    }

    private void setCompilerOptions(CompilationOptions compilationOptions) {
        CompilerOptions options = CompilerOptions.getInstance(this.compilerContext);
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(compilationOptions.offlineBuild()));
        options.put(CompilerOptionName.SKIP_TESTS, Boolean.toString(compilationOptions.skipTests()));
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(compilationOptions.experimental()));
        options.put(CompilerOptionName.OBSERVABILITY_INCLUDED, Boolean.toString(compilationOptions.observabilityIncluded()));
    }

    static PackageCompilation from(PackageContext rootPackageContext) {
        PackageResolution packageResolution = rootPackageContext.getResolution();
        return new PackageCompilation(rootPackageContext, packageResolution);
    }

    public PackageResolution getResolution() {
        return this.packageResolution;
    }

    public DiagnosticResult diagnosticResult() {
        if (!this.compiled) {
            this.compile();
        }
        return this.diagnosticResult;
    }

    public SemanticModel getSemanticModel(ModuleId moduleId) {
        ModuleContext moduleContext;
        if (!this.compiled) {
            this.compile();
        }
        if ((moduleContext = this.rootPackageContext.moduleContext(moduleId)).compilationState() != ModuleCompilationState.COMPILED) {
            throw new IllegalStateException("Semantic model cannot be retrieved when the module is in compilation state '" + moduleContext.compilationState().name() + "'. This is an internal error which will be fixed in a later release.");
        }
        return new BallerinaSemanticModel(moduleContext.bLangPackage(), this.compilerContext);
    }

    public BLangPackage defaultModuleBLangPackage() {
        return this.rootPackageContext.defaultModuleContext().bLangPackage();
    }

    <T extends CompilerBackend> T getCompilerBackend(CompilerBackend.TargetPlatform targetPlatform, Function<CompilerBackend.TargetPlatform, T> backendCreator) {
        return (T)this.compilerBackends.computeIfAbsent(targetPlatform, backendCreator);
    }

    PackageContext packageContext() {
        return this.rootPackageContext;
    }

    private void compile() {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (ModuleContext moduleContext : this.packageResolution.topologicallySortedModuleList()) {
            moduleContext.compile(this.compilerContext);
            diagnostics.addAll(moduleContext.diagnostics());
        }
        this.addOtherDiagnostics(diagnostics);
        this.diagnosticResult = new DefaultDiagnosticResult(diagnostics);
        this.compiled = true;
    }

    private void addOtherDiagnostics(List<Diagnostic> diagnostics) {
        Optional<BallerinaToml> ballerinaTomlOptional = this.rootPackageContext.ballerinaToml();
        if (ballerinaTomlOptional.isEmpty()) {
            return;
        }
        BallerinaToml ballerinaToml = ballerinaTomlOptional.get();
        diagnostics.addAll(ballerinaToml.diagnostics().allDiagnostics);
    }
}

