/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import java.util.Objects;
import java.util.UUID;

public final class PackageId {
    private final UUID id;
    private final String packageName;

    private PackageId(UUID id, String packageName) {
        this.id = id;
        this.packageName = packageName;
    }

    public static PackageId create(String packageName) {
        return new PackageId(UUID.randomUUID(), packageName);
    }

    public UUID id() {
        return this.id;
    }

    public String toString() {
        return "PackageId{packageName='" + this.packageName + "', id=" + this.id + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageId packageId = (PackageId)o;
        return this.id.equals(packageId.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

