/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.SemanticVersion;
import java.util.Objects;

public class PackageVersion {
    private final SemanticVersion version;

    private PackageVersion(SemanticVersion version) {
        this.version = version;
    }

    public static PackageVersion from(String versionString) {
        return PackageVersion.from(SemanticVersion.from(versionString));
    }

    public static PackageVersion from(SemanticVersion version) {
        return new PackageVersion(version);
    }

    public SemanticVersion value() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageVersion that = (PackageVersion)o;
        return this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public String toString() {
        return this.version.toString();
    }

    public SemanticVersion.VersionCompatibilityResult compareTo(PackageVersion other) {
        return this.version.compareTo(other.version);
    }
}

