/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.BuildOptionsBuilder;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.environment.ProjectEnvironment;
import java.nio.file.Path;
import org.ballerinalang.compiler.CompilerOptionName;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public abstract class Project {
    protected final Path sourceRoot;
    private Package currentPackage;
    private final BuildOptions buildOptions;
    private final ProjectEnvironment projectEnvironment;
    private final ProjectKind projectKind;

    protected Project(ProjectKind projectKind, Path projectPath, ProjectEnvironmentBuilder projectEnvironmentBuilder, BuildOptions buildOptions) {
        this.projectKind = projectKind;
        this.sourceRoot = projectPath;
        this.projectEnvironment = projectEnvironmentBuilder.build(this);
        this.buildOptions = buildOptions;
    }

    protected Project(ProjectKind projectKind, Path projectPath, ProjectEnvironmentBuilder projectEnvironmentBuilder) {
        this.projectKind = projectKind;
        this.sourceRoot = projectPath;
        this.projectEnvironment = projectEnvironmentBuilder.build(this);
        this.buildOptions = new BuildOptionsBuilder().build();
    }

    public ProjectKind kind() {
        return this.projectKind;
    }

    public Package currentPackage() {
        return this.currentPackage;
    }

    public void addPackage(PackageConfig packageConfig) {
        Package newPackage = Package.from(this, packageConfig, this.buildOptions.compilationOptions());
        this.setCurrentPackage(newPackage);
    }

    public Path sourceRoot() {
        return this.sourceRoot;
    }

    protected void setCurrentPackage(Package currentPackage) {
        this.currentPackage = currentPackage;
    }

    public ProjectEnvironment projectEnvironmentContext() {
        return this.projectEnvironment;
    }

    public BuildOptions buildOptions() {
        return this.buildOptions;
    }

    protected void populateCompilerContext() {
        CompilerContext compilerContext = this.projectEnvironmentContext().getService(CompilerContext.class);
        CompilerOptions options = CompilerOptions.getInstance(compilerContext);
        options.put(CompilerOptionName.PROJECT_DIR, this.sourceRoot().toAbsolutePath().toString());
    }
}

