/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.directory;

import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import java.nio.file.Path;
import java.util.Optional;

public class ProjectLoader {
    public static Project loadProject(Path path) {
        return ProjectLoader.loadProject(path, ProjectEnvironmentBuilder.getDefaultBuilder());
    }

    public static Project loadProject(Path path, ProjectEnvironmentBuilder projectEnvironmentBuilder) {
        Path absProjectPath = Optional.of(path.toAbsolutePath()).get();
        if (absProjectPath.toFile().isDirectory()) {
            Path projectRoot = "modules".equals(Optional.of(absProjectPath.getParent()).get().toFile().getName()) ? Optional.of(Optional.of(absProjectPath.getParent()).get().getParent()).get() : absProjectPath;
            return BuildProject.load(projectEnvironmentBuilder, projectRoot);
        }
        Path projectRoot = Optional.of(absProjectPath.getParent()).get();
        if (ProjectLoader.hasBallerinaToml(projectRoot)) {
            return BuildProject.load(projectEnvironmentBuilder, projectRoot);
        }
        Path testsRoot = Optional.of(absProjectPath.getParent()).get();
        projectRoot = Optional.of(testsRoot.getParent()).get();
        if ("tests".equals(testsRoot.toFile().getName()) && ProjectLoader.hasBallerinaToml(projectRoot)) {
            return BuildProject.load(projectEnvironmentBuilder, projectRoot);
        }
        Path modulesRoot = Optional.of(Optional.of(absProjectPath.getParent()).get().getParent()).get();
        projectRoot = modulesRoot.getParent();
        if ("modules".equals(modulesRoot.toFile().getName()) && ProjectLoader.hasBallerinaToml(projectRoot)) {
            return BuildProject.load(projectEnvironmentBuilder, projectRoot);
        }
        modulesRoot = Optional.of(Optional.of(testsRoot.getParent()).get().getParent()).get();
        projectRoot = modulesRoot.getParent();
        if ("modules".equals(modulesRoot.toFile().getName()) && ProjectLoader.hasBallerinaToml(projectRoot)) {
            return BuildProject.load(projectEnvironmentBuilder, projectRoot);
        }
        return SingleFileProject.load(projectEnvironmentBuilder, absProjectPath);
    }

    public static Optional<DocumentId> getDocumentId(Path documentFilePath, BuildProject project) {
        Path parent = Optional.of(documentFilePath.getParent()).get();
        for (ModuleId moduleId : project.currentPackage().moduleIds()) {
            Optional<Path> modulePath = project.modulePath(moduleId);
            if (!modulePath.isPresent() || !parent.equals(modulePath.get()) && !parent.equals(modulePath.get().resolve("tests"))) continue;
            Module module = project.currentPackage().module(moduleId);
            for (DocumentId documentId : module.documentIds()) {
                if (!module.document(documentId).name().equals(Optional.of(documentFilePath.getFileName()).get().toString())) continue;
                return Optional.of(documentId);
            }
            for (DocumentId documentId : module.testDocumentIds()) {
                if (!module.document(documentId).name().equals("tests/" + Optional.of(documentFilePath.getFileName()).get().toString())) continue;
                return Optional.of(documentId);
            }
        }
        return Optional.empty();
    }

    private static boolean hasBallerinaToml(Path filePath) {
        return filePath.resolve("Ballerina.toml").toFile().exists();
    }
}

