/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.directory;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.BuildOptionsBuilder;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.PackageConfigCreator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class SingleFileProject
extends Project {
    public static SingleFileProject load(ProjectEnvironmentBuilder environmentBuilder, Path filePath) {
        PackageConfig packageConfig = PackageConfigCreator.createSingleFileProjectConfig(filePath);
        SingleFileProject singleFileProject = new SingleFileProject(environmentBuilder, filePath, new BuildOptionsBuilder().build());
        singleFileProject.addPackage(packageConfig);
        return singleFileProject;
    }

    public static SingleFileProject load(Path filePath) {
        return SingleFileProject.load(filePath, new BuildOptionsBuilder().build());
    }

    public static SingleFileProject load(Path filePath, BuildOptions buildOptions) {
        System.setProperty("ballerina.offline.flag", String.valueOf(buildOptions.offlineBuild()));
        PackageConfig packageConfig = PackageConfigCreator.createSingleFileProjectConfig(filePath);
        ProjectEnvironmentBuilder environmentBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        SingleFileProject singleFileProject = new SingleFileProject(environmentBuilder, filePath, buildOptions);
        singleFileProject.addPackage(packageConfig);
        return singleFileProject;
    }

    private SingleFileProject(ProjectEnvironmentBuilder environmentBuilder, Path filePath, BuildOptions buildOptions) {
        super(ProjectKind.SINGLE_FILE_PROJECT, SingleFileProject.createTempProjectRoot(), environmentBuilder, buildOptions);
        this.populateCompilerContext();
    }

    private static Path createTempProjectRoot() {
        try {
            return Files.createTempDirectory("ballerina-project" + System.nanoTime(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProjectException("error while creating project root directory for single file execution. ", e);
        }
    }
}

