/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.environment;

import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.PackageRepository;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.internal.environment.BallerinaDistribution;
import io.ballerina.projects.internal.environment.BallerinaUserHome;
import io.ballerina.projects.internal.environment.DefaultEnvironment;
import io.ballerina.projects.internal.environment.DefaultPackageResolver;
import io.ballerina.projects.internal.environment.EnvironmentPackageCache;
import io.ballerina.projects.internal.repositories.BallerinaDistributionRepository;
import java.nio.file.Path;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class EnvironmentBuilder {
    private PackageRepository ballerinaCentralRepo;
    private Path ballerinaHome;
    private Path userHome;

    public static EnvironmentBuilder getBuilder() {
        return new EnvironmentBuilder();
    }

    public static Environment buildDefault() {
        return new EnvironmentBuilder().build();
    }

    public EnvironmentBuilder setUserHome(Path userHome) {
        this.userHome = userHome;
        return this;
    }

    public EnvironmentBuilder setBallerinaHome(Path ballerinaHome) {
        this.ballerinaHome = ballerinaHome;
        return this;
    }

    public EnvironmentBuilder setBallerinaCentralRepository(PackageRepository ballerinaCentralRepo) {
        this.ballerinaCentralRepo = ballerinaCentralRepo;
        return this;
    }

    public Environment build() {
        DefaultEnvironment environment = new DefaultEnvironment();
        BallerinaDistribution ballerinaDistribution = this.getBallerinaDistribution(environment);
        BallerinaDistributionRepository distributionRepository = ballerinaDistribution.packageRepository();
        environment.addService(PackageRepository.class, distributionRepository);
        EnvironmentPackageCache packageCache = new EnvironmentPackageCache();
        environment.addService(PackageCache.class, packageCache);
        if (this.ballerinaCentralRepo == null) {
            BallerinaUserHome ballerinaUserHome = this.getBallerinaUserHome(environment);
            this.ballerinaCentralRepo = ballerinaUserHome.remotePackageRepository();
        }
        DefaultPackageResolver packageResolver = new DefaultPackageResolver(distributionRepository, this.ballerinaCentralRepo, packageCache);
        environment.addService(PackageResolver.class, packageResolver);
        CompilerContext compilerContext = EnvironmentBuilder.populateCompilerContext();
        environment.addService(CompilerContext.class, compilerContext);
        ballerinaDistribution.loadLangLibPackages(compilerContext, packageResolver);
        return environment;
    }

    private BallerinaDistribution getBallerinaDistribution(DefaultEnvironment environment) {
        return this.ballerinaHome != null ? BallerinaDistribution.from(environment, this.ballerinaHome) : BallerinaDistribution.from(environment);
    }

    private BallerinaUserHome getBallerinaUserHome(DefaultEnvironment environment) {
        return this.userHome != null ? BallerinaUserHome.from(environment, this.userHome) : BallerinaUserHome.from(environment);
    }

    private static CompilerContext populateCompilerContext() {
        CompilerContext compilerContext = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance(compilerContext);
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        options.put(CompilerOptionName.PROJECT_API_INITIATED_COMPILATION, Boolean.toString(true));
        return compilerContext;
    }
}

