/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.internal.DocumentData;
import io.ballerina.projects.internal.ModuleData;
import io.ballerina.projects.internal.PackageData;
import io.ballerina.projects.internal.ProjectFiles;
import io.ballerina.projects.internal.balo.DependencyGraphJson;
import io.ballerina.projects.internal.balo.ModuleDependency;
import io.ballerina.projects.internal.model.Dependency;
import io.ballerina.projects.internal.model.PackageJson;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BaloFiles {
    private static final Gson gson = new Gson();

    private BaloFiles() {
    }

    static PackageData loadPackageData(Path balrPath, PackageManifest packageManifest) {
        PackageData packageData;
        block8: {
            URI zipURI = URI.create("jar:" + balrPath.toUri().toString());
            FileSystem zipFileSystem = FileSystems.newFileSystem(zipURI, new HashMap());
            try {
                String pkgName = packageManifest.name().toString();
                Path defaultModulePathInBalo = zipFileSystem.getPath("modules", pkgName);
                ModuleData defaultModule = BaloFiles.loadModule(defaultModulePathInBalo);
                Path modulesPathInBalo = zipFileSystem.getPath("modules", new String[0]);
                List<ModuleData> otherModules = BaloFiles.loadOtherModules(modulesPathInBalo, defaultModulePathInBalo);
                packageData = PackageData.from(balrPath, defaultModule, otherModules);
                if (zipFileSystem == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFileSystem != null) {
                        try {
                            zipFileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to read balr file:" + balrPath);
                }
            }
            zipFileSystem.close();
        }
        return packageData;
    }

    private static void validatePackageJson(PackageJson packageJson, Path balrPath) {
        if (packageJson.getOrganization() == null || "".equals(packageJson.getOrganization())) {
            throw new ProjectException("'organization' does not exists in 'package.json': " + balrPath);
        }
        if (packageJson.getName() == null || "".equals(packageJson.getName())) {
            throw new ProjectException("'name' does not exists in 'package.json': " + balrPath);
        }
        if (packageJson.getVersion() == null || "".equals(packageJson.getVersion())) {
            throw new ProjectException("'version' does not exists in 'package.json': " + balrPath);
        }
    }

    private static ModuleData loadModule(Path modulePath) {
        if (Files.notExists(modulePath, new LinkOption[0])) {
            throw new ProjectException("The 'modules' directory does not exists in '" + modulePath + "'");
        }
        String moduleName = String.valueOf(modulePath.getFileName());
        if (moduleName.contains(".")) {
            moduleName = moduleName.split("\\.")[1];
            moduleName = moduleName.replace("/", "");
        }
        if (!ProjectUtils.validateModuleName(moduleName)) {
            throw new ProjectException("Invalid module name : '" + moduleName + "' :\nModule name can only contain alphanumerics, underscores and periods and the maximum length is 256 characters: " + modulePath);
        }
        List<DocumentData> srcDocs = ProjectFiles.loadDocuments(modulePath);
        List<DocumentData> testSrcDocs = Collections.emptyList();
        return ModuleData.from(modulePath, moduleName, srcDocs, testSrcDocs);
    }

    private static List<ModuleData> loadOtherModules(Path modulesDirPath, Path defaultModulePath) {
        List<ModuleData> list;
        block8: {
            Stream<Path> pathStream = Files.walk(modulesDirPath, 1, new FileVisitOption[0]);
            try {
                list = pathStream.filter(path -> !path.equals(modulesDirPath)).filter(path -> path.getFileName() != null && !path.getFileName().equals(defaultModulePath.getFileName())).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(BaloFiles::loadModule).collect(Collectors.toList());
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to read modules from directory: " + modulesDirPath, e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    public static PackageManifest createPackageManifest(Path balrPath) {
        PackageManifest packageManifest;
        block9: {
            URI zipURI = URI.create("jar:" + balrPath.toAbsolutePath().toUri().toString());
            FileSystem zipFileSystem = FileSystems.newFileSystem(zipURI, new HashMap());
            try {
                Path packageJsonPath = zipFileSystem.getPath("package.json", new String[0]);
                if (Files.notExists(packageJsonPath, new LinkOption[0])) {
                    throw new ProjectException("package.json does not exists in '" + balrPath + "'");
                }
                PackageJson packageJson = BaloFiles.readPackageJson(balrPath, packageJsonPath);
                BaloFiles.validatePackageJson(packageJson, balrPath);
                BaloFiles.extractPlatformLibraries(zipFileSystem, packageJson, balrPath);
                packageManifest = BaloFiles.getPackageManifest(packageJson);
                if (zipFileSystem == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFileSystem != null) {
                        try {
                            zipFileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to read balr file:" + balrPath);
                }
            }
            zipFileSystem.close();
        }
        return packageManifest;
    }

    static DependencyGraphResult createPackageDependencyGraph(Path balrPath, String packageName) {
        DependencyGraphResult dependencyGraphResult;
        block9: {
            URI zipURI = URI.create("jar:" + balrPath.toAbsolutePath().toUri().toString());
            FileSystem zipFileSystem = FileSystems.newFileSystem(zipURI, new HashMap());
            try {
                Path dependencyGraphJsonPath = zipFileSystem.getPath("dependency-graph.json", new String[0]);
                if (Files.notExists(dependencyGraphJsonPath, new LinkOption[0])) {
                    throw new ProjectException("dependency-graph.json does not exists in '" + balrPath + "'");
                }
                DependencyGraphJson dependencyGraphJson = BaloFiles.readDependencyGraphJson(balrPath, dependencyGraphJsonPath);
                DependencyGraph<PackageDescriptor> packageDependencyGraph = BaloFiles.createPackageDependencyGraph(dependencyGraphJson.getPackageDependencyGraph());
                Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDescriptorListMap = BaloFiles.createModuleDescDependencies(dependencyGraphJson.getModuleDependencies());
                dependencyGraphResult = new DependencyGraphResult(packageDependencyGraph, moduleDescriptorListMap);
                if (zipFileSystem == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFileSystem != null) {
                        try {
                            zipFileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to read balr file:" + balrPath);
                }
            }
            zipFileSystem.close();
        }
        return dependencyGraphResult;
    }

    private static void extractPlatformLibraries(FileSystem zipFileSystem, PackageJson packageJson, Path balrPath) {
        if (packageJson.getPlatformDependencies() == null) {
            return;
        }
        packageJson.getPlatformDependencies().forEach(dependency -> {
            Path libPath = balrPath.getParent().resolve(dependency.getPath());
            if (!Files.exists(libPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(libPath.getParent(), new FileAttribute[0]);
                    Files.copy(zipFileSystem.getPath(dependency.getPath(), new String[0]), libPath, new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to extract platform dependency:" + libPath.getFileName(), e);
                }
            }
            dependency.setPath(libPath.toString());
        });
    }

    private static PackageManifest getPackageManifest(PackageJson packageJson) {
        PackageDescriptor pkgDesc = PackageDescriptor.from(PackageOrg.from(packageJson.getOrganization()), PackageName.from(packageJson.getName()), PackageVersion.from(packageJson.getVersion()));
        List<PackageManifest.Dependency> dependencies = packageJson.getDependencies() != null ? packageJson.getDependencies() : Collections.emptyList();
        HashMap<String, PackageManifest.Platform> platforms = new HashMap<String, PackageManifest.Platform>(Collections.emptyMap());
        if (packageJson.getPlatformDependencies() != null) {
            ArrayList<Map<String, Object>> platformDependencies = new ArrayList<Map<String, Object>>();
            packageJson.getPlatformDependencies().forEach(dependency -> {
                String jsonStr = gson.toJson(dependency);
                platformDependencies.add(gson.fromJson(jsonStr, Map.class));
            });
            PackageManifest.Platform platform = new PackageManifest.Platform(platformDependencies);
            platforms.put(packageJson.getPlatform(), platform);
        }
        return PackageManifest.from(pkgDesc, dependencies, platforms, Collections.emptyMap());
    }

    private static PackageJson readPackageJson(Path balrPath, Path packageJsonPath) {
        PackageJson packageJson;
        try {
            packageJson = gson.fromJson((Reader)Files.newBufferedReader(packageJsonPath), PackageJson.class);
        }
        catch (JsonSyntaxException e) {
            throw new ProjectException("Invalid package.json format in '" + balrPath + "'");
        }
        catch (JsonIOException | IOException e) {
            throw new ProjectException("Failed to read the package.json in '" + balrPath + "'");
        }
        return packageJson;
    }

    private static DependencyGraph<PackageDescriptor> createPackageDependencyGraph(List<Dependency> packageDependencyGraph) {
        DependencyGraph.DependencyGraphBuilder<PackageDescriptor> graphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder();
        for (Dependency dependency : packageDependencyGraph) {
            PackageDescriptor pkg = PackageDescriptor.from(PackageOrg.from(dependency.getOrg()), PackageName.from(dependency.getName()), PackageVersion.from(dependency.getVersion()));
            HashSet<PackageDescriptor> dependentPackages = new HashSet<PackageDescriptor>();
            for (Dependency dependencyPkg : dependency.getDependencies()) {
                dependentPackages.add(PackageDescriptor.from(PackageOrg.from(dependencyPkg.getOrg()), PackageName.from(dependencyPkg.getName()), PackageVersion.from(dependencyPkg.getVersion())));
            }
            graphBuilder.addDependencies(pkg, dependentPackages);
        }
        return graphBuilder.build();
    }

    private static Map<ModuleDescriptor, List<ModuleDescriptor>> createModuleDescDependencies(List<ModuleDependency> modDepEntries) {
        return modDepEntries.stream().collect(Collectors.toMap(BaloFiles::getModuleDescriptorFromDependencyEntry, modDepEntry -> BaloFiles.createModDescriptorList(modDepEntry.getDependencies())));
    }

    private static ModuleDescriptor getModuleDescriptorFromDependencyEntry(ModuleDependency modDepEntry) {
        PackageDescriptor pkgDesc = PackageDescriptor.from(PackageOrg.from(modDepEntry.getOrg()), PackageName.from(modDepEntry.getPackageName()), PackageVersion.from(modDepEntry.getVersion()));
        ModuleName moduleName = ModuleName.from(modDepEntry.getModuleName(), pkgDesc.org());
        return ModuleDescriptor.from(moduleName, pkgDesc);
    }

    private static List<ModuleDescriptor> createModDescriptorList(List<ModuleDependency> modDepEntries) {
        return modDepEntries.stream().map(BaloFiles::getModuleDescriptorFromDependencyEntry).collect(Collectors.toList());
    }

    private static DependencyGraphJson readDependencyGraphJson(Path balrPath, Path dependencyGraphJsonPath) {
        DependencyGraphJson dependencyGraphJson;
        try {
            dependencyGraphJson = gson.fromJson((Reader)Files.newBufferedReader(dependencyGraphJsonPath), DependencyGraphJson.class);
        }
        catch (JsonSyntaxException e) {
            throw new ProjectException("Invalid dependency-graph.json format in '" + balrPath + "'");
        }
        catch (JsonIOException | IOException e) {
            throw new ProjectException("Failed to read the dependency-graph.json in '" + balrPath + "'");
        }
        return dependencyGraphJson;
    }

    public static class DependencyGraphResult {
        private final DependencyGraph<PackageDescriptor> packageDependencyGraph;
        private final Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDependencies;

        DependencyGraphResult(DependencyGraph<PackageDescriptor> packageDependencyGraph, Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDependencies) {
            this.packageDependencyGraph = packageDependencyGraph;
            this.moduleDependencies = moduleDependencies;
        }

        DependencyGraph<PackageDescriptor> packageDependencyGraph() {
            return this.packageDependencyGraph;
        }

        public Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDependencies() {
            return this.moduleDependencies;
        }
    }
}

