/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PackageDependencyGraphBuilder {
    private final Map<GraphNode, PackageDescriptor> graphNodes = new HashMap<GraphNode, PackageDescriptor>();
    private final Map<GraphNode, Set<GraphNode>> dependenciesMap = new HashMap<GraphNode, Set<GraphNode>>();

    public static PackageDependencyGraphBuilder getInstance() {
        return new PackageDependencyGraphBuilder();
    }

    public PackageDependencyGraphBuilder addNode(PackageDescriptor pkgDesc) {
        GraphNode newNode = new GraphNode(pkgDesc, PackageDependencyScope.DEFAULT);
        this.addInternal(newNode);
        return this;
    }

    public PackageDependencyGraphBuilder addTestNode(PackageDescriptor pkgDesc) {
        GraphNode newNode = new GraphNode(pkgDesc, PackageDependencyScope.TEST_ONLY);
        this.addInternal(newNode);
        return this;
    }

    public PackageDependencyGraphBuilder addDependency(PackageDescriptor dependent, PackageDescriptor dependency) {
        GraphNode dependentNode = new GraphNode(dependent, PackageDependencyScope.DEFAULT);
        this.addInternal(dependentNode);
        this.addDependencyInternal(dependentNode, new GraphNode(dependency, PackageDependencyScope.DEFAULT));
        return this;
    }

    public PackageDependencyGraphBuilder addTestDependency(PackageDescriptor dependent, PackageDescriptor dependency) {
        GraphNode dependentNode = new GraphNode(dependent, PackageDependencyScope.TEST_ONLY);
        this.addInternal(dependentNode);
        this.addDependencyInternal(dependentNode, new GraphNode(dependency, PackageDependencyScope.TEST_ONLY));
        return this;
    }

    public PackageDependencyGraphBuilder addDependencies(PackageDescriptor dependent, Collection<PackageDescriptor> dependencies) {
        GraphNode dependentNode = new GraphNode(dependent, PackageDependencyScope.DEFAULT);
        this.addInternal(dependentNode);
        for (PackageDescriptor dependency : dependencies) {
            this.addDependencyInternal(dependentNode, new GraphNode(dependency, PackageDependencyScope.DEFAULT));
        }
        return this;
    }

    public PackageDependencyGraphBuilder addTestDependencies(PackageDescriptor dependent, Collection<PackageDescriptor> dependencies) {
        GraphNode dependentNode = new GraphNode(dependent, PackageDependencyScope.TEST_ONLY);
        this.addInternal(dependentNode);
        for (PackageDescriptor dependency : dependencies) {
            this.addDependencyInternal(dependentNode, new GraphNode(dependency, PackageDependencyScope.TEST_ONLY));
        }
        return this;
    }

    public PackageDependencyGraphBuilder mergeGraph(DependencyGraph<PackageDescriptor> theirGraph) {
        for (PackageDescriptor theirPkgDesc : theirGraph.getNodes()) {
            Collection<PackageDescriptor> theirPkgDescDeps = theirGraph.getDirectDependencies(theirPkgDesc);
            this.addDependencies(theirPkgDesc, theirPkgDescDeps);
        }
        return this;
    }

    public PackageDependencyGraphBuilder mergeTestDependencyGraph(DependencyGraph<PackageDescriptor> theirGraph) {
        for (PackageDescriptor theirPkgDesc : theirGraph.getNodes()) {
            Collection<PackageDescriptor> theirPkgDescDeps = theirGraph.getDirectDependencies(theirPkgDesc);
            this.addTestDependencies(theirPkgDesc, theirPkgDescDeps);
        }
        return this;
    }

    public DependencyGraph<PackageDescriptor> build() {
        DependencyGraph.DependencyGraphBuilder<PackageDescriptor> graphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder();
        for (Map.Entry<GraphNode, Set<GraphNode>> dependencyMapEntry : this.dependenciesMap.entrySet()) {
            Set pkgDescValues;
            GraphNode graphNodeKey = dependencyMapEntry.getKey();
            Set<GraphNode> graphNodeValues = dependencyMapEntry.getValue();
            PackageDescriptor pkgDescKey = this.graphNodes.get(graphNodeKey);
            if (graphNodeValues.isEmpty()) {
                pkgDescValues = Collections.emptySet();
            } else {
                pkgDescValues = new HashSet(graphNodeValues.size());
                for (GraphNode graphNodeValue : graphNodeValues) {
                    pkgDescValues.add(this.graphNodes.get(graphNodeValue));
                }
            }
            graphBuilder.addDependencies(pkgDescKey, pkgDescValues);
        }
        return graphBuilder.build();
    }

    public DependencyGraph<ResolvedPackageDependency> buildPackageDependencyGraph(PackageDescriptor rootPkgDesc, PackageResolver packageResolver, PackageCache packageCache, Project currentProject) {
        HashMap<PackageDescriptor, ResolvedPackageDependency> packageDependencyMap = new HashMap<PackageDescriptor, ResolvedPackageDependency>();
        packageDependencyMap.put(rootPkgDesc, new ResolvedPackageDependency(currentProject.currentPackage(), PackageDependencyScope.DEFAULT));
        GraphNode rooPkgGraphNode = new GraphNode(rootPkgDesc, PackageDependencyScope.DEFAULT);
        Set<GraphNode> directDependencyNodes = this.dependenciesMap.get(rooPkgGraphNode);
        for (GraphNode directDependencyNode : directDependencyNodes) {
            Optional<Package> optionalPackage = packageCache.getPackage(directDependencyNode.org, directDependencyNode.name, directDependencyNode.pkgDesc.version());
            if (!optionalPackage.isPresent()) continue;
            packageDependencyMap.put(directDependencyNode.pkgDesc, new ResolvedPackageDependency((Package)optionalPackage.get(), directDependencyNode.scope));
        }
        List transitiveDependencyNodes = this.dependenciesMap.keySet().stream().filter(keyNode -> !keyNode.equals(rooPkgGraphNode)).filter(keyNode -> !directDependencyNodes.contains(keyNode)).collect(Collectors.toList());
        ArrayList<ResolutionRequest> resolutionRequests = new ArrayList<ResolutionRequest>();
        for (GraphNode transitiveDependencyNode : transitiveDependencyNodes) {
            PackageDescriptor pkgDesc = this.graphNodes.get(transitiveDependencyNode);
            resolutionRequests.add(ResolutionRequest.from(pkgDesc, transitiveDependencyNode.scope));
        }
        List<ResolutionResponse> resolutionResponses = packageResolver.resolvePackages(resolutionRequests, currentProject);
        int transitiveNodeIndex = 0;
        for (ResolutionResponse resolutionResponse : resolutionResponses) {
            GraphNode transitiveDepNode = (GraphNode)transitiveDependencyNodes.get(transitiveNodeIndex);
            if (resolutionResponse.resolutionStatus() == ResolutionResponse.ResolutionStatus.UNRESOLVED) {
                throw new ProjectException("Transitive dependency cannot be found: org=" + transitiveDepNode.org + ", package=" + transitiveDepNode.name + ", version=" + transitiveDepNode.pkgDesc.version());
            }
            packageDependencyMap.put(transitiveDepNode.pkgDesc, new ResolvedPackageDependency(resolutionResponse.resolvedPackage(), transitiveDepNode.scope));
            ++transitiveNodeIndex;
        }
        DependencyGraph.DependencyGraphBuilder<ResolvedPackageDependency> depGraphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder();
        for (Map.Entry<GraphNode, Set<GraphNode>> graphNodeEntrySet : this.dependenciesMap.entrySet()) {
            GraphNode graphNode = graphNodeEntrySet.getKey();
            ResolvedPackageDependency directPackageDep = (ResolvedPackageDependency)packageDependencyMap.get(graphNode.pkgDesc);
            if (directPackageDep == null) continue;
            ArrayList<ResolvedPackageDependency> resolvedTransitiveDeps = new ArrayList<ResolvedPackageDependency>();
            Set<GraphNode> transitiveDepGraphNodes = graphNodeEntrySet.getValue();
            for (GraphNode transitiveDepGraphNode : transitiveDepGraphNodes) {
                ResolvedPackageDependency transitivePackageDep = (ResolvedPackageDependency)packageDependencyMap.get(transitiveDepGraphNode.pkgDesc);
                if (transitivePackageDep == null) continue;
                resolvedTransitiveDeps.add(transitivePackageDep);
            }
            depGraphBuilder.addDependencies(directPackageDep, resolvedTransitiveDeps);
        }
        return depGraphBuilder.build();
    }

    private void addInternal(GraphNode newNode) {
        PackageDescriptor newPkgDesc = newNode.pkgDesc;
        PackageDescriptor existingPkgDesc = this.graphNodes.get(newNode);
        if (existingPkgDesc == null) {
            this.graphNodes.put(newNode, newPkgDesc);
            this.dependenciesMap.put(newNode, new HashSet());
            return;
        }
        if (newNode.scope == PackageDependencyScope.TEST_ONLY) {
            return;
        }
        this.handleVersionCompatibility(existingPkgDesc, newPkgDesc, newNode);
    }

    private void addDependencyInternal(GraphNode dependentNode, GraphNode dependencyNode) {
        this.addInternal(dependencyNode);
        this.dependenciesMap.get(dependentNode).add(dependencyNode);
    }

    private void handleVersionCompatibility(PackageDescriptor existingPkgDesc, PackageDescriptor newPkgDesc, GraphNode graphNode) {
        PackageVersion existingVersion = existingPkgDesc.version();
        PackageVersion newVersion = newPkgDesc.version();
        SemanticVersion.VersionCompatibilityResult versionCompatibilityResult = existingVersion.compareTo(newVersion);
        switch (versionCompatibilityResult) {
            case GREATER_THAN: 
            case EQUAL: {
                return;
            }
            case INCOMPATIBLE: {
                throw new ProjectException("Two incompatible versions exist in the dependency graph: " + newPkgDesc.org() + "/" + newPkgDesc.name() + " versions: " + existingVersion + ", " + newVersion);
            }
            case LESS_THAN: {
                this.graphNodes.put(graphNode, newPkgDesc);
            }
        }
    }

    private static class GraphNode {
        private final PackageOrg org;
        private final PackageName name;
        private final PackageDescriptor pkgDesc;
        private final PackageDependencyScope scope;

        private GraphNode(PackageDescriptor pkgDesc, PackageDependencyScope scope) {
            this.org = pkgDesc.org();
            this.name = pkgDesc.name();
            this.pkgDesc = pkgDesc;
            this.scope = scope;
        }

        public boolean equals(Object otherNode) {
            if (this == otherNode) {
                return true;
            }
            if (otherNode == null || this.getClass() != otherNode.getClass()) {
                return false;
            }
            GraphNode otherGraphNode = (GraphNode)otherNode;
            return this.org.equals(otherGraphNode.org) && this.name.equals(otherGraphNode.name);
        }

        public int hashCode() {
            return Objects.hash(this.org, this.name);
        }
    }
}

