/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.compiler.syntax.tree.CommitActionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.RetryStatementNode;
import io.ballerina.compiler.syntax.tree.RollbackStatementNode;
import io.ballerina.compiler.syntax.tree.ServiceBodyNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TransactionStatementNode;
import java.util.List;
import java.util.stream.Collectors;

public class TransactionImportValidator
extends NodeVisitor {
    private boolean importTransactionPackage;

    public boolean shouldImportTransactionPackage(ModulePartNode modulePartNode) {
        modulePartNode.accept(this);
        return this.importTransactionPackage;
    }

    @Override
    public void visit(TransactionStatementNode transactionStatementNode) {
        this.importTransactionPackage = true;
    }

    @Override
    public void visit(CommitActionNode commitActionNode) {
        this.importTransactionPackage = true;
    }

    @Override
    public void visit(RollbackStatementNode rollbackStatementNode) {
        this.importTransactionPackage = true;
    }

    @Override
    public void visit(RetryStatementNode retryStatementNode) {
        StatementNode statementNode = retryStatementNode.retryBody();
        if (statementNode.kind() == SyntaxKind.TRANSACTION_STATEMENT) {
            this.importTransactionPackage = true;
        }
    }

    @Override
    public void visit(ServiceBodyNode serviceDeclarationNode) {
        super.visit(serviceDeclarationNode);
    }

    @Override
    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        List qualifiers = functionDefinitionNode.qualifierList().stream().map(Token::text).collect(Collectors.toList());
        if (qualifiers.contains(SyntaxKind.TRANSACTIONAL_KEYWORD.stringValue()) && qualifiers.contains(SyntaxKind.RESOURCE_KEYWORD.stringValue())) {
            this.importTransactionPackage = true;
        }
        super.visit(functionDefinitionNode);
    }

    @Override
    protected void visitSyntaxNode(Node node) {
        if (this.importTransactionPackage) {
            return;
        }
        super.visitSyntaxNode(node);
    }
}

