/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.environment;

import io.ballerina.projects.Bootstrap;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.internal.repositories.BallerinaDistributionRepository;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public final class BallerinaDistribution {
    private static final String BALLERINA_HOME_KEY = "ballerina.home";
    private static final String langLibBootstrapPhase = System.getProperty("BOOTSTRAP_LANG_LIB");
    private final Path ballerinaHomeDirPath;
    private final BallerinaDistributionRepository distributionRepository;

    private BallerinaDistribution(Environment environment, Path ballerinaHomeDirPath) {
        this.ballerinaHomeDirPath = ballerinaHomeDirPath;
        this.distributionRepository = BallerinaDistributionRepository.from(environment, this.ballerinaHomeDirPath);
    }

    public static BallerinaDistribution from(Environment environment) {
        String ballerinaHome = System.getProperty(BALLERINA_HOME_KEY);
        if (ballerinaHome == null) {
            throw new IllegalStateException("ballerina.home property is not set");
        }
        return BallerinaDistribution.from(environment, Paths.get(ballerinaHome, new String[0]));
    }

    public static BallerinaDistribution from(Environment environment, Path ballerinaHomeDirPath) {
        BallerinaDistribution.validateBallerinaHomeDir(ballerinaHomeDirPath);
        return new BallerinaDistribution(environment, ballerinaHomeDirPath);
    }

    public BallerinaDistributionRepository packageRepository() {
        return this.distributionRepository;
    }

    public void loadLangLibPackages(CompilerContext compilerContext, PackageResolver packageResolver) {
        if (langLibBootstrapPhase == null) {
            Bootstrap bootstrap = new Bootstrap(packageResolver);
            bootstrap.loadLangLibSymbols(compilerContext);
        }
    }

    private static void validateBallerinaHomeDir(Path ballerinaHomeDirPath) {
        if (Files.notExists(ballerinaHomeDirPath, new LinkOption[0])) {
            throw new ProjectException("Ballerina distribution directory does not exists in `" + ballerinaHomeDirPath + "'");
        }
        if (!Files.isDirectory(ballerinaHomeDirPath, new LinkOption[0])) {
            throw new ProjectException("Invalid Ballerina distribution directory: " + ballerinaHomeDirPath);
        }
        if (langLibBootstrapPhase != null) {
            return;
        }
    }
}

