/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.environment;

import io.ballerina.projects.ProjectException;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.internal.repositories.RemotePackageRepository;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.ballerinalang.toml.model.Settings;
import org.ballerinalang.toml.parser.SettingsProcessor;

public final class BallerinaUserHome {
    private final Path ballerinaUserHomeDirPath;
    private final RemotePackageRepository remotePackageRepository;

    private BallerinaUserHome(Environment environment, Path ballerinaUserHomeDirPath) {
        this.ballerinaUserHomeDirPath = ballerinaUserHomeDirPath;
        this.remotePackageRepository = RemotePackageRepository.from(environment, ballerinaUserHomeDirPath, this.readSettings());
    }

    public static BallerinaUserHome from(Environment environment, Path ballerinaUserHomeDirPath) {
        BallerinaUserHome.validateBallerinaUserHomeDir(ballerinaUserHomeDirPath);
        return new BallerinaUserHome(environment, ballerinaUserHomeDirPath);
    }

    public static BallerinaUserHome from(Environment environment) {
        String userHomeDir = System.getProperty("user.home");
        if (userHomeDir == null || userHomeDir.isEmpty()) {
            throw new ProjectException("unable to get user home directory");
        }
        Path homeRepoPath = Paths.get(userHomeDir, ".ballerina");
        return BallerinaUserHome.from(environment, homeRepoPath);
    }

    public RemotePackageRepository remotePackageRepository() {
        return this.remotePackageRepository;
    }

    private Settings readSettings() {
        Path settingsFilePath = this.ballerinaUserHomeDirPath.resolve("Settings.toml");
        if (Files.notExists(settingsFilePath, new LinkOption[0])) {
            try {
                Files.createFile(settingsFilePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProjectException("Settings.toml does not exists in '" + this.ballerinaUserHomeDirPath + "', File creation also failed");
            }
        }
        try {
            return SettingsProcessor.parseTomlContentFromFile(settingsFilePath);
        }
        catch (IOException e) {
            return new Settings();
        }
    }

    private static void validateBallerinaUserHomeDir(Path ballerinaUserHomeDirPath) {
        if (Files.notExists(ballerinaUserHomeDirPath, new LinkOption[0]) || !Files.isDirectory(ballerinaUserHomeDirPath, new LinkOption[0])) {
            try {
                Files.createDirectory(ballerinaUserHomeDirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProjectException("Ballerina user home directory does not exists in '" + ballerinaUserHomeDirPath + "', Directory creation also failed");
            }
        }
    }
}

