/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.environment;

import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.PackageRepository;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import io.ballerina.projects.internal.environment.WritablePackageCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DefaultPackageResolver
implements PackageResolver {
    private final PackageRepository ballerinaDistRepo;
    private final PackageRepository ballerinaCentralRepo;
    private final WritablePackageCache packageCache;

    public DefaultPackageResolver(PackageRepository ballerinaDistRepo, PackageRepository ballerinaCentralRepo, PackageCache packageCache) {
        this.ballerinaDistRepo = ballerinaDistRepo;
        this.ballerinaCentralRepo = ballerinaCentralRepo;
        this.packageCache = (WritablePackageCache)packageCache;
    }

    @Override
    public List<ResolutionResponse> resolvePackages(List<ResolutionRequest> packageLoadRequests, Project currentProject) {
        if (packageLoadRequests.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ResolutionResponse> resolutionResponses = new ArrayList<ResolutionResponse>();
        Package currentPkg = currentProject != null ? currentProject.currentPackage() : null;
        for (ResolutionRequest resolutionRequest : packageLoadRequests) {
            ResolutionResponse.ResolutionStatus resolutionStatus;
            Package resolvedPackage = null;
            if (currentPkg != null && resolutionRequest.packageDescriptor().equals(currentPkg.descriptor())) {
                resolvedPackage = currentPkg;
            }
            if (resolvedPackage == null) {
                resolvedPackage = this.loadFromCache(resolutionRequest);
            }
            if (resolvedPackage == null) {
                resolvedPackage = this.resolveFromRepository(resolutionRequest);
            }
            if (resolvedPackage == null) {
                resolutionStatus = ResolutionResponse.ResolutionStatus.UNRESOLVED;
            } else {
                resolutionStatus = ResolutionResponse.ResolutionStatus.RESOLVED;
                this.packageCache.cache(resolvedPackage);
            }
            resolutionResponses.add(ResolutionResponse.from(resolutionStatus, resolvedPackage, resolutionRequest));
        }
        return resolutionResponses;
    }

    @Override
    public List<ResolutionResponse> resolvePackages(List<ResolutionRequest> resolutionRequests) {
        return this.resolvePackages(resolutionRequests, null);
    }

    private Package loadFromCache(ResolutionRequest resolutionRequest) {
        if (resolutionRequest.version().isEmpty()) {
            return null;
        }
        Optional<Package> resolvedPackage = this.packageCache.getPackage(resolutionRequest.orgName(), resolutionRequest.packageName(), resolutionRequest.version().get());
        return resolvedPackage.orElse(null);
    }

    private Package resolveFromRepository(ResolutionRequest resolutionRequest) {
        PackageRepository pkgRepoThatContainsLatestVersion;
        PackageVersion latestVersion;
        PackageDescriptor requestedPkgDesc = resolutionRequest.packageDescriptor();
        if (requestedPkgDesc.isLangLibPackage()) {
            return this.resolveLangLibPackage(resolutionRequest);
        }
        if (requestedPkgDesc.version() != null) {
            Optional<Package> resolvedPackage = this.ballerinaDistRepo.getPackage(resolutionRequest);
            if (resolvedPackage.isEmpty()) {
                resolvedPackage = this.ballerinaCentralRepo.getPackage(resolutionRequest);
            }
            return resolvedPackage.orElse(null);
        }
        List<PackageVersion> versionsInDistRepo = this.ballerinaDistRepo.getPackageVersions(resolutionRequest);
        List<PackageVersion> versionsInCentralRepo = this.ballerinaCentralRepo.getPackageVersions(resolutionRequest);
        if (versionsInDistRepo.isEmpty() && versionsInCentralRepo.isEmpty()) {
            return null;
        }
        PackageVersion latestVersionInDistRepo = this.findLatest(versionsInDistRepo);
        PackageVersion latestVersionInCentralRepo = this.findLatest(versionsInCentralRepo);
        if (latestVersionInDistRepo == null) {
            latestVersion = latestVersionInCentralRepo;
            pkgRepoThatContainsLatestVersion = this.ballerinaCentralRepo;
        } else if (latestVersionInCentralRepo == null) {
            latestVersion = latestVersionInDistRepo;
            pkgRepoThatContainsLatestVersion = this.ballerinaDistRepo;
        } else {
            latestVersion = DefaultPackageResolver.getLatest(latestVersionInDistRepo, latestVersionInCentralRepo);
            pkgRepoThatContainsLatestVersion = latestVersion.equals(latestVersionInDistRepo) ? this.ballerinaDistRepo : this.ballerinaCentralRepo;
        }
        ResolutionRequest newResolutionReq = ResolutionRequest.from(PackageDescriptor.from(resolutionRequest.orgName(), resolutionRequest.packageName(), latestVersion), resolutionRequest.scope());
        Optional<Package> packageOptional = pkgRepoThatContainsLatestVersion.getPackage(newResolutionReq);
        return packageOptional.orElse(null);
    }

    private Package resolveLangLibPackage(ResolutionRequest resolutionRequest) {
        Optional<Package> resolvedPackage;
        if (resolutionRequest.version().isPresent()) {
            resolvedPackage = this.ballerinaDistRepo.getPackage(resolutionRequest);
        } else {
            List<PackageVersion> versionList = this.ballerinaDistRepo.getPackageVersions(resolutionRequest);
            if (versionList.isEmpty()) {
                resolvedPackage = Optional.empty();
            } else {
                ResolutionRequest newResolutionReq = ResolutionRequest.from(PackageDescriptor.from(resolutionRequest.orgName(), resolutionRequest.packageName(), versionList.get(0)), resolutionRequest.scope());
                resolvedPackage = this.ballerinaDistRepo.getPackage(newResolutionReq);
            }
        }
        return resolvedPackage.orElseThrow(() -> new IllegalStateException("Ballerina langlib package cannot be found in Ballerina distribution: org=" + resolutionRequest.orgName() + ", name=" + resolutionRequest.packageName()));
    }

    private PackageVersion findLatest(List<PackageVersion> packageVersions) {
        if (packageVersions.isEmpty()) {
            return null;
        }
        PackageVersion latestVersion = packageVersions.get(0);
        for (PackageVersion pkgVersion : packageVersions) {
            latestVersion = DefaultPackageResolver.getLatest(latestVersion, pkgVersion);
        }
        return latestVersion;
    }

    public static PackageVersion getLatest(PackageVersion v1, PackageVersion v2) {
        SemanticVersion.VersionCompatibilityResult compResult = v1.compareTo(v2);
        if (compResult == SemanticVersion.VersionCompatibilityResult.LESS_THAN) {
            return v2;
        }
        if (compResult == SemanticVersion.VersionCompatibilityResult.INCOMPATIBLE) {
            return DefaultPackageResolver.getLatestFromIncompatible(v1, v2);
        }
        return v1;
    }

    private static PackageVersion getLatestFromIncompatible(PackageVersion v1, PackageVersion v2) {
        SemanticVersion semVar1 = v1.value();
        SemanticVersion semVar2 = v2.value();
        if (semVar1.major() == semVar2.major()) {
            if (semVar1.minor() == semVar2.minor()) {
                return semVar1.patch() < semVar2.patch() ? v2 : v1;
            }
            return semVar1.minor() < semVar2.minor() ? v2 : v1;
        }
        return semVar1.major() < semVar2.major() ? v2 : v1;
    }
}

