/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.environment;

import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import io.ballerina.projects.internal.environment.WritablePackageCache;
import java.util.List;
import java.util.Optional;

public class ProjectPackageCache
implements WritablePackageCache {
    private final Project project;
    private final WritablePackageCache globalPackageCache;

    public ProjectPackageCache(Project project, WritablePackageCache globalPackageCache) {
        this.project = project;
        this.globalPackageCache = globalPackageCache;
    }

    @Override
    public void cache(Package pkg) {
        this.globalPackageCache.cache(pkg);
    }

    @Override
    public Optional<Package> getPackage(PackageId packageId) {
        if (this.isCurrentPackage(packageId)) {
            return Optional.of(this.project.currentPackage());
        }
        return this.globalPackageCache.getPackage(packageId);
    }

    @Override
    public Package getPackageOrThrow(PackageId packageId) {
        if (this.isCurrentPackage(packageId)) {
            return this.project.currentPackage();
        }
        return this.globalPackageCache.getPackageOrThrow(packageId);
    }

    @Override
    public Optional<Package> getPackage(PackageOrg packageOrg, PackageName packageName, PackageVersion version) {
        if (this.isCurrentPackage(packageOrg, packageName, version)) {
            return Optional.of(this.project.currentPackage());
        }
        return this.globalPackageCache.getPackage(packageOrg, packageName, version);
    }

    @Override
    public List<Package> getPackages(PackageOrg packageOrg, PackageName packageName) {
        if (this.isCurrentPackage(packageOrg, packageName)) {
            return List.of(this.project.currentPackage());
        }
        return this.globalPackageCache.getPackages(packageOrg, packageName);
    }

    private boolean isCurrentPackage(PackageId packageId) {
        return this.project.currentPackage().packageId() == packageId;
    }

    private boolean isCurrentPackage(PackageOrg packageOrg, PackageName packageName) {
        PackageDescriptor descriptor = this.project.currentPackage().descriptor();
        return descriptor.org().equals(packageOrg) && descriptor.name().equals(packageName);
    }

    private boolean isCurrentPackage(PackageOrg packageOrg, PackageName packageName, PackageVersion version) {
        PackageDescriptor descriptor = this.project.currentPackage().descriptor();
        return descriptor.org().equals(packageOrg) && descriptor.name().equals(packageName) && descriptor.version().equals(version);
    }
}

