/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.jballerina;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.wso2.ballerinalang.compiler.CompiledJarFile;

public class JarWriter {
    public static ByteArrayOutputStream write(CompiledJarFile compiledJarFile) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JarWriter.writeJar(compiledJarFile, byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    private static Manifest getManifest(CompiledJarFile compiledJarFile) {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        compiledJarFile.getMainClassName().ifPresent(mainClassName -> mainAttributes.put(Attributes.Name.MAIN_CLASS, mainClassName));
        return manifest;
    }

    private static void writeJar(CompiledJarFile compiledJarFile, OutputStream outputStream) throws IOException {
        Manifest manifest = JarWriter.getManifest(compiledJarFile);
        try (JarOutputStream target = new JarOutputStream(outputStream, manifest);){
            Map<String, byte[]> jarEntries = compiledJarFile.getJarEntries();
            for (Map.Entry<String, byte[]> keyVal : jarEntries.entrySet()) {
                byte[] entryContent = keyVal.getValue();
                JarEntry entry = new JarEntry(keyVal.getKey());
                target.putNextEntry(entry);
                target.write(entryContent);
                target.closeEntry();
            }
        }
    }
}

