/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.model;

import io.ballerina.projects.Package;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;

public class Target {
    private final Path targetPath;
    private Path outputPath = null;
    private Path cache;
    private Path jarCachePath;
    private Path baloCachePath;
    private Path birCachePath;
    private Path testsCachePath;
    private Path binPath;
    private Path reportPath;
    private Path docPath;

    public Target(Path sourceRoot) throws IOException {
        this.targetPath = sourceRoot.resolve("target");
        this.cache = this.targetPath.resolve("cache");
        this.baloCachePath = this.targetPath.resolve("balo");
        this.jarCachePath = this.cache.resolve("jar_cache");
        this.birCachePath = this.cache.resolve("bir_cache");
        this.testsCachePath = this.cache.resolve("tests_cache");
        this.binPath = this.targetPath.resolve("bin");
        this.reportPath = this.targetPath.resolve("report");
        this.docPath = this.targetPath.resolve("apidocs");
        Files.createDirectories(this.targetPath, new FileAttribute[0]);
    }

    public Path getDocPath() throws IOException {
        Files.createDirectories(this.docPath, new FileAttribute[0]);
        return this.docPath;
    }

    public Path getBaloPath() throws IOException {
        Files.createDirectories(this.baloCachePath, new FileAttribute[0]);
        return this.baloCachePath;
    }

    public Path getJarCachePath() throws IOException {
        Files.createDirectories(this.jarCachePath, new FileAttribute[0]);
        return this.jarCachePath;
    }

    public Path getExecutablePath(Package pkg) throws IOException {
        if (this.outputPath != null) {
            return this.outputPath;
        }
        return this.getBinPath().resolve(ProjectUtils.getExecutableName(pkg));
    }

    public Path getBinPath() throws IOException {
        Files.createDirectories(this.binPath, new FileAttribute[0]);
        return this.binPath;
    }

    public Path getReportPath() throws IOException {
        Files.createDirectories(this.reportPath, new FileAttribute[0]);
        return this.reportPath;
    }

    public Path cachesPath() {
        return this.targetPath.resolve("cache");
    }

    public Path getBirCachePath() throws IOException {
        Files.createDirectories(this.birCachePath, new FileAttribute[0]);
        return this.birCachePath;
    }

    public Path getTestsCachePath() throws IOException {
        Files.createDirectories(this.testsCachePath, new FileAttribute[0]);
        return this.testsCachePath;
    }

    public Path path() {
        return this.targetPath;
    }

    public void setOutputPath(Path outputPath) throws IOException {
        Path parent;
        if (Files.exists(outputPath, new LinkOption[0])) {
            Files.delete(outputPath);
        }
        if ((parent = outputPath.getParent()) != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        this.outputPath = outputPath;
    }

    public void clean() throws IOException {
        FileUtils.deleteDirectory(this.cache.toFile());
        FileUtils.deleteDirectory(this.baloCachePath.toFile());
        FileUtils.deleteDirectory(this.binPath.toFile());
        FileUtils.deleteDirectory(this.docPath.toFile());
        FileUtils.deleteDirectory(this.reportPath.toFile());
    }
}

