/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.util;

import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryPredicate;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.toml.model.Proxy;
import org.wso2.ballerinalang.compiler.CompiledJarFile;
import org.wso2.ballerinalang.compiler.packaging.converters.URIDryConverter;
import org.wso2.ballerinalang.util.Lists;
import org.wso2.ballerinalang.util.RepoUtils;

public class ProjectUtils {
    private static final String USER_HOME = "user.home";
    private static final HashSet<String> excludeExtensions = new HashSet<String>(Lists.of("DSA", "SF"));

    public static boolean validateOrgName(String orgName) {
        String validRegex = "^[a-zA-Z0-9_]*$";
        return Pattern.matches(validRegex, orgName);
    }

    public static boolean validatePkgName(String packageName) {
        String validLanglib = "^lang.[a-z0-9_]*$";
        String validRegex = "^[a-zA-Z0-9_]*$";
        return Pattern.matches(validRegex, packageName) || Pattern.matches(validLanglib, packageName);
    }

    public static boolean validateModuleName(String moduleName) {
        String validRegex = "^[a-zA-Z0-9_.]*$";
        return Pattern.matches(validRegex, moduleName);
    }

    public static Path findProjectRoot(Path filePath) {
        if (filePath != null) {
            if ((filePath = filePath.toAbsolutePath().normalize()).toFile().isDirectory() && Files.exists(filePath.resolve("Ballerina.toml"), new LinkOption[0])) {
                return filePath;
            }
            return ProjectUtils.findProjectRoot(filePath.getParent());
        }
        return null;
    }

    public static boolean isBallerinaProject(Path sourceRoot) {
        Path ballerinaToml = sourceRoot.resolve("Ballerina.toml");
        return Files.isDirectory(sourceRoot, new LinkOption[0]) && Files.exists(ballerinaToml, new LinkOption[0]) && Files.isRegularFile(ballerinaToml, new LinkOption[0]);
    }

    public static String guessOrgName() {
        String guessOrgName = System.getProperty("user.name");
        guessOrgName = guessOrgName == null ? "my_org" : guessOrgName.toLowerCase(Locale.getDefault());
        return guessOrgName;
    }

    public static String guessPkgName(String packageName) {
        if (!ProjectUtils.validatePkgName(packageName)) {
            return packageName.replaceAll("[^a-zA-Z0-9_]", "_");
        }
        return packageName;
    }

    public static String getBaloName(PackageManifest pkgDesc) {
        return ProjectUtils.getBaloName(pkgDesc.org().toString(), pkgDesc.name().toString(), pkgDesc.version().toString(), null);
    }

    public static String getBaloName(String org, String pkgName, String version, String platform) {
        if (platform == null || "".equals(platform)) {
            platform = "any";
        }
        return org + "-" + pkgName + "-" + platform + "-" + version + ".balo";
    }

    public static String getJarFileName(Package pkg) {
        return pkg.packageOrg().toString() + "-" + pkg.packageName().toString() + "-" + pkg.packageVersion() + ".jar";
    }

    public static String getExecutableName(Package pkg) {
        return pkg.packageName().toString() + ".jar";
    }

    public static String getOrgFromBaloName(String baloName) {
        return baloName.split("-")[0];
    }

    public static String getPackageNameFromBaloName(String baloName) {
        return baloName.split("-")[1];
    }

    public static String getVersionFromBaloName(String baloName) {
        String versionAndExtension = baloName.split("-")[3];
        int extensionIndex = versionAndExtension.indexOf(".balo");
        return versionAndExtension.substring(0, extensionIndex);
    }

    public static Path getBalHomePath() {
        return Paths.get(System.getProperty("ballerina.home"), new String[0]);
    }

    public static String getBallerinaPackVersion() {
        String string;
        block8: {
            InputStream inputStream = ProjectUtils.class.getResourceAsStream("/META-INF/tool.properties");
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = properties.getProperty("ballerina.packVersion");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    return "unknown";
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static Path getBallerinaRTJarPath() {
        String ballerinaVersion = RepoUtils.getBallerinaPackVersion();
        String runtimeJarName = "ballerina-rt-" + ballerinaVersion + ".jar";
        return ProjectUtils.getBalHomePath().resolve("bre").resolve("lib").resolve(runtimeJarName);
    }

    public static Path getChoreoRuntimeJarPath() {
        String ballerinaVersion = RepoUtils.getBallerinaPackVersion();
        String runtimeJarName = "ballerina-choreo-extension-rt-" + ballerinaVersion + ".jar";
        return ProjectUtils.getBalHomePath().resolve("bre").resolve("lib").resolve(runtimeJarName);
    }

    public static List<Path> testDependencies() {
        ArrayList<Path> dependencies = new ArrayList<Path>();
        String ballerinaVersion = RepoUtils.getBallerinaPackVersion();
        Path homeLibPath = ProjectUtils.getBalHomePath().resolve("bre").resolve("lib");
        String testRuntimeJarName = "testerina-runtime-" + ballerinaVersion + ".jar";
        String testCoreJarName = "testerina-core-" + ballerinaVersion + ".jar";
        String langJarName = "ballerina-lang-" + ballerinaVersion + ".jar";
        Path testRuntimeJarPath = homeLibPath.resolve(testRuntimeJarName);
        Path testCoreJarPath = homeLibPath.resolve(testCoreJarName);
        Path langJarPath = homeLibPath.resolve(langJarName);
        Path jacocoCoreJarPath = homeLibPath.resolve("org.jacoco.core-0.8.5.jar");
        Path jacocoReportJarPath = homeLibPath.resolve("org.jacoco.report-0.8.5.jar");
        Path asmJarPath = homeLibPath.resolve("asm-7.1.jar");
        Path asmTreeJarPath = homeLibPath.resolve("asm-tree-7.2.jar");
        Path asmCommonsJarPath = homeLibPath.resolve("asm-commons-7.2.jar");
        Path diffUtilsJarPath = homeLibPath.resolve("java-diff-utils-4.5.jar");
        dependencies.add(testRuntimeJarPath);
        dependencies.add(testCoreJarPath);
        dependencies.add(langJarPath);
        dependencies.add(jacocoCoreJarPath);
        dependencies.add(jacocoReportJarPath);
        dependencies.add(asmJarPath);
        dependencies.add(asmTreeJarPath);
        dependencies.add(asmCommonsJarPath);
        dependencies.add(diffUtilsJarPath);
        return dependencies;
    }

    public static void assembleExecutableJar(Manifest manifest, List<CompiledJarFile> compiledPackageJarList, Path targetPath) throws IOException {
        HashSet<String> copiedEntries = new HashSet<String>();
        try (ZipArchiveOutputStream outStream = new ZipArchiveOutputStream(new BufferedOutputStream(new FileOutputStream(targetPath.toString())));){
            ProjectUtils.copyRuntimeJar(outStream, ProjectUtils.getBallerinaRTJarPath(), copiedEntries);
            JarArchiveEntry e = new JarArchiveEntry("META-INF/MANIFEST.MF");
            outStream.putArchiveEntry(e);
            manifest.write(new BufferedOutputStream(outStream));
            outStream.closeArchiveEntry();
            for (CompiledJarFile compiledJarFile : compiledPackageJarList) {
                for (Map.Entry<String, byte[]> keyVal : compiledJarFile.getJarEntries().entrySet()) {
                    ProjectUtils.copyEntry(copiedEntries, outStream, keyVal);
                }
            }
        }
    }

    private static void copyEntry(HashSet<String> copiedEntries, ZipArchiveOutputStream outStream, Map.Entry<String, byte[]> keyVal) throws IOException {
        String entryName = keyVal.getKey();
        if (!ProjectUtils.isCopiedOrExcludedEntry(entryName, copiedEntries)) {
            byte[] entryContent = keyVal.getValue();
            JarArchiveEntry entry = new JarArchiveEntry(entryName);
            outStream.putArchiveEntry(entry);
            outStream.write(entryContent);
            outStream.closeArchiveEntry();
        }
    }

    public static void copyRuntimeJar(ZipArchiveOutputStream outStream, Path ballerinaRTJarPath, HashSet<String> copiedEntries) throws IOException {
        HashMap services = new HashMap();
        ZipFile zipFile = new ZipFile(ballerinaRTJarPath.toString());
        ZipArchiveEntryPredicate predicate = entry -> {
            String entryName = entry.getName();
            if (entryName.equals("META-INF/MANIFEST.MF")) {
                return false;
            }
            if (entryName.startsWith("META-INF/services")) {
                StringBuilder s = (StringBuilder)services.get(entryName);
                if (s == null) {
                    s = new StringBuilder();
                    services.put(entryName, s);
                }
                char c = '\n';
                try (BufferedInputStream inStream = new BufferedInputStream(zipFile.getInputStream(entry));){
                    int len;
                    while ((len = inStream.read()) != -1) {
                        c = (char)len;
                        s.append(c);
                    }
                }
                catch (IOException e) {
                    throw new ProjectException(e);
                }
                if (c != '\n') {
                    s.append('\n');
                }
                return false;
            }
            if (ProjectUtils.isCopiedOrExcludedEntry(entryName, copiedEntries)) {
                return false;
            }
            copiedEntries.add(entryName);
            return true;
        };
        zipFile.copyRawEntries(outStream, predicate);
        zipFile.close();
        for (Map.Entry entry2 : services.entrySet()) {
            String s = (String)entry2.getKey();
            StringBuilder service = (StringBuilder)entry2.getValue();
            JarArchiveEntry e = new JarArchiveEntry(s);
            outStream.putArchiveEntry(e);
            outStream.write(service.toString().getBytes(StandardCharsets.UTF_8));
            outStream.closeArchiveEntry();
        }
    }

    private static boolean isCopiedOrExcludedEntry(String entryName, HashSet<String> copiedEntries) {
        return copiedEntries.contains(entryName) || excludeExtensions.contains(entryName.substring(entryName.lastIndexOf(".") + 1));
    }

    public static String getJarFileName(Module module) {
        String jarName;
        if (module.packageInstance().manifest().org().anonymous()) {
            DocumentId documentId = module.documentIds().iterator().next();
            String documentName = module.document(documentId).name();
            jarName = FileUtils.getFileNameWithoutExtension(documentName);
        } else {
            ModuleName moduleName = module.moduleName();
            jarName = moduleName.isDefaultModuleName() ? moduleName.packageName().toString() : moduleName.moduleNamePart();
        }
        return jarName;
    }

    public static Path createAndGetHomeReposPath() {
        Path homeRepoPath;
        String homeRepoDir = System.getenv("BALLERINA_HOME_DIR");
        if (homeRepoDir == null || homeRepoDir.isEmpty()) {
            String userHomeDir = System.getProperty(USER_HOME);
            if (userHomeDir == null || userHomeDir.isEmpty()) {
                throw new BLangCompilerException("Error creating home repository: unable to get user home directory");
            }
            homeRepoPath = Paths.get(userHomeDir, ".ballerina");
        } else {
            homeRepoPath = Paths.get(homeRepoDir, new String[0]);
        }
        homeRepoPath = homeRepoPath.toAbsolutePath();
        if (Files.exists(homeRepoPath, new LinkOption[0]) && !Files.isDirectory(homeRepoPath, LinkOption.NOFOLLOW_LINKS)) {
            throw new BLangCompilerException("Home repository is not a directory: " + homeRepoPath.toString());
        }
        return homeRepoPath;
    }

    public static boolean isModuleExist(Path projectPath, String moduleName) {
        Path modulePath = projectPath.resolve("modules").resolve(moduleName);
        return Files.exists(modulePath, new LinkOption[0]);
    }

    public static java.net.Proxy initializeProxy(Proxy proxy) {
        if (!"".equals(proxy.getHost())) {
            InetSocketAddress proxyInet = new InetSocketAddress(proxy.getHost(), proxy.getPort());
            if (!"".equals(proxy.getUserName()) && "".equals(proxy.getPassword())) {
                URIDryConverter.RemoteAuthenticator authenticator = new URIDryConverter.RemoteAuthenticator();
                Authenticator.setDefault(authenticator);
            }
            return new java.net.Proxy(Proxy.Type.HTTP, proxyInet);
        }
        return null;
    }
}

