/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api;

import java.util.Objects;

public class Module {
    private String org;
    private String name;
    private String version;
    private int hashCode;

    public Module(String org, String name, String version) {
        this.org = org;
        this.name = name;
        this.version = version;
        this.hashCode = Objects.hash(org, name, version);
    }

    public Module(String org, String name) {
        this.org = org;
        this.name = name;
        this.version = "";
        this.hashCode = Objects.hash(org, name);
    }

    public String getOrg() {
        return this.org;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module bPackage = (Module)o;
        return Objects.equals(this.org, bPackage.org) && Objects.equals(this.name, bPackage.name) && Objects.equals(this.version, bPackage.version);
    }

    public String toString() {
        if (".".equals(this.name)) {
            return this.name;
        }
        Object orgName = "";
        if (this.org != null && !this.org.equals("$anon")) {
            orgName = this.org + "/";
        }
        if (this.version == null || this.version.equals("")) {
            return (String)orgName + this.name;
        }
        return (String)orgName + this.name + ":" + this.version;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

