/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.creators;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.ErrorType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.JsonType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.types.XmlType;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BErrorType;
import io.ballerina.runtime.internal.types.BField;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BJsonType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BStreamType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.BXmlType;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeCreator {
    public static ArrayType createArrayType(Type elementType) {
        return new BArrayType(elementType);
    }

    public static ArrayType createArrayType(Type elementType, boolean readonly) {
        return new BArrayType(elementType, readonly);
    }

    public static ArrayType createArrayType(Type elementType, int size) {
        return new BArrayType(elementType, size, false);
    }

    public static ArrayType createArrayType(Type elementType, int size, boolean readonly) {
        return new BArrayType(elementType, size, readonly);
    }

    public static TupleType createTupleType(List<Type> typeList) {
        return new BTupleType(typeList);
    }

    public static TupleType createTupleType(List<Type> typeList, int typeFlags) {
        return new BTupleType(typeList, typeFlags);
    }

    public static TupleType createTupleType(List<Type> typeList, Type restType, int typeFlags, boolean readonly) {
        return new BTupleType(typeList, restType, typeFlags, readonly);
    }

    public static MapType createMapType(Type constraint) {
        return new BMapType(constraint);
    }

    public static MapType createMapType(Type constraint, boolean readonly) {
        return new BMapType(constraint, readonly);
    }

    public static MapType createMapType(String typeName, Type constraint, Module module) {
        return new BMapType(typeName, constraint, module);
    }

    public static MapType createMapType(String typeName, Type constraint, Module module, boolean readonly) {
        return new BMapType(typeName, constraint, module, readonly);
    }

    public static RecordType createRecordType(String typeName, Module module, long flags, boolean sealed, int typeFlags) {
        return new BRecordType(typeName, module, flags, sealed, typeFlags);
    }

    public static RecordType createRecordType(String typeName, Module module, long flags, Map<String, Field> fields, Type restFieldType, boolean sealed, int typeFlags) {
        return new BRecordType(typeName, module, flags, fields, restFieldType, sealed, typeFlags);
    }

    public static ObjectType createObjectType(String typeName, Module module, long flags) {
        return new BObjectType(typeName, module, flags);
    }

    public static StreamType createStreamType(Type constraint) {
        return new BStreamType(constraint);
    }

    public static StreamType createStreamType(String typeName, Type constraint, Module modulePath) {
        return new BStreamType(typeName, constraint, modulePath);
    }

    public static UnionType createUnionType(List<Type> memberTypes) {
        return new BUnionType(memberTypes);
    }

    public static UnionType createUnionType(List<Type> memberTypes, int typeFlags) {
        return new BUnionType(memberTypes, typeFlags, false);
    }

    public static UnionType createUnionType(List<Type> memberTypes, boolean readonly) {
        return new BUnionType(memberTypes, readonly);
    }

    public static UnionType createUnionType(List<Type> memberTypes, int typeFlags, boolean readonly) {
        return new BUnionType(memberTypes, typeFlags, readonly);
    }

    public static ErrorType createErrorType(String typeName, Module module) {
        return new BErrorType(typeName, module);
    }

    public static ErrorType createErrorType(String typeName, Module module, Type detailType) {
        return new BErrorType(typeName, module, detailType);
    }

    public static Field createField(Type fieldType, String fieldName, long flags) {
        return new BField(fieldType, fieldName, flags);
    }

    public static TableType createTableType(Type constraint, String[] fieldNames, boolean readonly) {
        return new BTableType(constraint, fieldNames, readonly);
    }

    public static TableType createTableType(Type constraint, Type keyType, boolean readonly) {
        return new BTableType(constraint, keyType, readonly);
    }

    public static TableType createTableType(Type constraint, boolean readonly) {
        return new BTableType(constraint, readonly);
    }

    public static XmlType createXMLType(String typeName, Type constraint, Module module) {
        return new BXmlType(typeName, constraint, module);
    }

    public static XmlType createXMLType(String typeName, Module module, int tag, boolean readonly) {
        return new BXmlType(typeName, module, tag, readonly);
    }

    public static XmlType createXMLType(Type constraint, boolean readonly) {
        return new BXmlType(constraint, readonly);
    }

    public static JsonType createJSONType(String typeName, Module module, boolean readonly) {
        return new BJsonType(typeName, module, readonly);
    }

    public static FiniteType createFiniteType(String typeName) {
        return new BFiniteType(typeName);
    }

    public static FiniteType createFiniteType(String typeName, Set<Object> values, int typeFlags) {
        return new BFiniteType(typeName, values, typeFlags);
    }
}

