/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.utils;

import io.ballerina.runtime.api.types.JsonType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.internal.JsonGenerator;
import io.ballerina.runtime.internal.JsonParser;
import io.ballerina.runtime.internal.values.ErrorValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class JsonUtils {
    public static Object parse(InputStream in) throws BError {
        return JsonParser.parse(in);
    }

    public static Object parse(InputStream in, String charsetName) throws BError {
        return JsonParser.parse(in, charsetName);
    }

    public static Object parse(BString jsonStr) throws BError {
        return JsonParser.parse(jsonStr.getValue());
    }

    public static Object parse(BString jsonStr, NonStringValueProcessingMode mode) throws BError {
        return JsonParser.parse(jsonStr.getValue(), mode);
    }

    public static Object parse(String jsonStr) throws BError {
        return JsonParser.parse(jsonStr);
    }

    public static Object parse(String jsonStr, NonStringValueProcessingMode mode) throws BError {
        return JsonParser.parse(jsonStr, mode);
    }

    public static Object parse(Reader reader, NonStringValueProcessingMode mode) throws BError {
        return JsonParser.parse(reader, mode);
    }

    public static Object parse(BTable bTable) {
        return io.ballerina.runtime.internal.JsonUtils.toJSON(bTable);
    }

    public static Object parse(BArray bArray) {
        return io.ballerina.runtime.internal.JsonUtils.convertArrayToJSON(bArray);
    }

    public static Object parse(BMap<BString, ?> map, JsonType targetType) {
        return io.ballerina.runtime.internal.JsonUtils.convertMapToJSON(map, targetType);
    }

    public static BMap<BString, ?> convertJSONToMap(Object json, MapType mapType) throws BError {
        return io.ballerina.runtime.internal.JsonUtils.jsonToMap(json, mapType);
    }

    public static BMap<BString, Object> convertJSONToRecord(Object record, StructureType structType) throws BError {
        return io.ballerina.runtime.internal.JsonUtils.convertJSONToRecord(record, structType);
    }

    public static Object convertJSON(Object source, Type targetType) throws BError {
        return io.ballerina.runtime.internal.JsonUtils.convertJSON(source, targetType);
    }

    public static Object convertUnionTypeToJSON(Object source, JsonType targetType) throws BError {
        return io.ballerina.runtime.internal.JsonUtils.convertUnionTypeToJSON(source, targetType);
    }

    public static void serialize(Object json, OutputStream out) throws BError {
        try {
            JsonGenerator gen = new JsonGenerator(out);
            gen.serialize(json);
            gen.flush();
        }
        catch (IOException e) {
            throw new ErrorValue(StringUtils.fromString(e.getMessage()), (Object)e);
        }
    }

    public static void serialize(Object json, OutputStream out, Charset charset) throws BError {
        try {
            JsonGenerator gen = new JsonGenerator(out, charset);
            gen.serialize(json);
            gen.flush();
        }
        catch (IOException e) {
            throw new ErrorValue(StringUtils.fromString(e.getMessage()), (Object)e);
        }
    }

    public static void serialize(Object json, Writer writer) throws BError {
        try {
            JsonGenerator gen = new JsonGenerator(writer);
            gen.serialize(json);
            gen.flush();
        }
        catch (IOException e) {
            throw new ErrorValue(StringUtils.fromString(e.getMessage()), (Object)e);
        }
    }

    public static enum NonStringValueProcessingMode {
        FROM_JSON_STRING,
        FROM_JSON_FLOAT_STRING,
        FROM_JSON_DECIMAL_STRING;

    }
}

