/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.utils;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BFiniteType;

public class TypeUtils {
    public static boolean isValueType(Type type) {
        if (type == PredefinedTypes.TYPE_INT || type == PredefinedTypes.TYPE_BYTE || type == PredefinedTypes.TYPE_FLOAT || type == PredefinedTypes.TYPE_DECIMAL || type == PredefinedTypes.TYPE_STRING || type == PredefinedTypes.TYPE_BOOLEAN) {
            return true;
        }
        if (type != null && type.getTag() == 34) {
            for (Object value : ((BFiniteType)type).valueSpace) {
                if (TypeUtils.isValueType(TypeChecker.getType(value))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Type getTypeFromName(String typeName) {
        switch (typeName) {
            case "int": {
                return PredefinedTypes.TYPE_INT;
            }
            case "byte": {
                return PredefinedTypes.TYPE_BYTE;
            }
            case "float": {
                return PredefinedTypes.TYPE_FLOAT;
            }
            case "decimal": {
                return PredefinedTypes.TYPE_DECIMAL;
            }
            case "string": {
                return PredefinedTypes.TYPE_STRING;
            }
            case "boolean": {
                return PredefinedTypes.TYPE_BOOLEAN;
            }
            case "json": {
                return PredefinedTypes.TYPE_JSON;
            }
            case "xml": {
                return PredefinedTypes.TYPE_XML;
            }
            case "map": {
                return PredefinedTypes.TYPE_MAP;
            }
            case "future": {
                return PredefinedTypes.TYPE_FUTURE;
            }
            case "stream": {
                return PredefinedTypes.TYPE_STREAM;
            }
            case "any": {
                return PredefinedTypes.TYPE_ANY;
            }
            case "typedesc": {
                return PredefinedTypes.TYPE_TYPEDESC;
            }
            case "()": {
                return PredefinedTypes.TYPE_NULL;
            }
            case "xml-attributes": {
                return PredefinedTypes.TYPE_XML_ATTRIBUTES;
            }
            case "error": {
                return PredefinedTypes.TYPE_ERROR;
            }
            case "anydata": {
                return PredefinedTypes.TYPE_ANYDATA;
            }
        }
        throw new IllegalStateException("Unknown type name");
    }

    public static Type fromString(String typeName) {
        if (typeName.endsWith("[]")) {
            String elementTypeName = typeName.substring(0, typeName.length() - 2);
            Type elemType = TypeUtils.fromString(elementTypeName);
            return new BArrayType(elemType);
        }
        return TypeUtils.getTypeFromName(typeName);
    }

    public static Type getType(Object value) {
        return TypeChecker.getType(value);
    }

    public static boolean isSameType(Type sourceType, Type targetType) {
        return TypeChecker.isSameType(sourceType, targetType);
    }
}

